/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.mortbay.http.HandlerContext;
import org.mortbay.http.Version;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.Code;
import org.mortbay.util.Frame;
import org.mortbay.util.Log;
import org.mortbay.util.LogSink;
import org.mortbay.util.Resource;

public class Context
implements ServletContext,
HttpSessionContext {
    private static final String CONTEXT_LOG = "org.mortbay.jetty.servlet.Context.LogSink";
    private static final boolean __Slosh2Slash = File.separatorChar == '\\';
    public static final String __SessionId = "jsessionid";
    public static final String __SessionUrlPrefix = ";jsessionid=";
    public static final int __distantFuture = 628992000;
    private static long __nextSessionId = System.currentTimeMillis();
    private ServletHandler _handler;
    private HandlerContext _handlerContext;
    private LogSink _logSink;
    private int _dftMaxIdleSecs = -1;
    private SessionScavenger _scavenger = null;
    private Map _sessions = new HashMap();
    private int _scavengeDelay = 30000;
    private static /* synthetic */ Class class$Lorg$mortbay$jetty$servlet$ServletHandler;
    private static /* synthetic */ Class class$Lorg$mortbay$jetty$servlet$Context;

    ServletHandler getHandler() {
        return this._handler;
    }

    HandlerContext getHandlerContext() {
        return this._handlerContext;
    }

    void setHandlerContext(HandlerContext hc) {
        this._handlerContext = hc;
        if (this._handlerContext != null) {
            this._logSink = (LogSink)this._handlerContext.getAttribute(CONTEXT_LOG);
        }
    }

    ServletHandler getServletHandler() {
        return this._handler;
    }

    public String getContextPath() {
        return this._handlerContext.getContextPath();
    }

    public ServletContext getContext(String uri) {
        HandlerContext context = this._handlerContext;
        ServletHandler handler = (ServletHandler)context.getHttpServer().findHandler(class$Lorg$mortbay$jetty$servlet$ServletHandler != null ? class$Lorg$mortbay$jetty$servlet$ServletHandler : (class$Lorg$mortbay$jetty$servlet$ServletHandler = Context.class$("org.mortbay.jetty.servlet.ServletHandler")), uri, context.getHosts());
        if (handler != null) {
            return handler.getContext();
        }
        return null;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 2;
    }

    public String getMimeType(String file) {
        return this._handlerContext.getMimeByExtension(file);
    }

    public URL getResource(String uriInContext) throws MalformedURLException {
        Resource baseResource = this._handlerContext.getBaseResource();
        uriInContext = Resource.canonicalPath(uriInContext);
        if (baseResource == null || uriInContext == null) {
            return null;
        }
        try {
            Resource resource = baseResource.addPath(uriInContext);
            if (resource.exists()) {
                return resource.getURL();
            }
            String aliasedUri = this._handlerContext.getResourceAlias(uriInContext);
            if (aliasedUri != null) {
                return this.getResource(aliasedUri);
            }
        }
        catch (IllegalArgumentException e) {
            Code.ignore(e);
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            Code.warning(e);
        }
        return null;
    }

    public InputStream getResourceAsStream(String uriInContext) {
        try {
            URL url = this.getResource(uriInContext);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (MalformedURLException e) {
            Code.ignore(e);
        }
        catch (IOException e) {
            Code.ignore(e);
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String uriInContext) {
        if (uriInContext == null || !uriInContext.startsWith("/")) {
            return null;
        }
        try {
            String pathInContext = uriInContext;
            String query = null;
            int q = 0;
            q = pathInContext.indexOf(63);
            if (q > 0) {
                pathInContext = uriInContext.substring(0, q);
                query = uriInContext.substring(q + 1);
            }
            return new Dispatcher(this, pathInContext, query);
        }
        catch (Exception e) {
            Code.ignore(e);
            return null;
        }
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        try {
            return new Dispatcher(this, name);
        }
        catch (Exception e) {
            Code.ignore(e);
            return null;
        }
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration getServlets() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getServletNames() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public void log(String msg) {
        if (this._logSink != null) {
            this._logSink.log("EVENT  ", msg, new Frame(2), System.currentTimeMillis());
        } else {
            Log.message("EVENT  ", msg, new Frame(2));
        }
    }

    public void log(Exception e, String msg) {
        Code.warning(msg, e);
    }

    public void log(String msg, Throwable th) {
        Code.warning(msg, th);
    }

    public String getRealPath(String path) {
        Resource baseResource;
        if (Code.debug()) {
            Code.debug((Object)"getRealPath of ", path, (Object)" in ", this);
        }
        if (__Slosh2Slash) {
            path = path.replace('\\', '/');
        }
        if ((baseResource = this._handlerContext.getBaseResource()) == null) {
            return null;
        }
        try {
            Resource resource = baseResource.addPath(path);
            File file = resource.getFile();
            return file == null ? "null" : file.getAbsolutePath();
        }
        catch (IOException e) {
            Code.warning(e);
            return null;
        }
    }

    public String getServerInfo() {
        return Version.__Version;
    }

    public String getInitParameter(String param) {
        return this._handlerContext.getInitParameter(param);
    }

    public Enumeration getInitParameterNames() {
        return this._handlerContext.getInitParameterNames();
    }

    public Object getAttribute(String name) {
        if ("javax.servlet.context.tempdir".equals(name)) {
            File tempDir = (File)this._handlerContext.getAttribute("javax.servlet.context.tempdir");
            if (tempDir == null) {
                try {
                    tempDir = File.createTempFile("JettyContext", "");
                    if (tempDir.exists()) {
                        tempDir.delete();
                    }
                    tempDir.mkdir();
                    tempDir.deleteOnExit();
                    this._handlerContext.setAttribute("javax.servlet.context.tempdir", tempDir);
                }
                catch (Exception e) {
                    Code.warning(e);
                }
            }
            Code.debug((Object)"TempDir=", (Object)tempDir);
        }
        return this._handlerContext.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this._handlerContext.getAttributeNames();
    }

    public void setAttribute(String name, Object value) {
        if (name.startsWith("org.mortbay.http")) {
            Code.warning("Servlet attempted update of " + name);
            return;
        }
        this._handlerContext.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        if (name.startsWith("org.mortbay.http")) {
            Code.warning("Servlet attempted update of " + name);
            return;
        }
        this._handlerContext.removeAttribute(name);
    }

    public Enumeration getIds() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public HttpSession getSession(String id) {
        return null;
    }

    public int sessionCount() {
        return this._sessions.size();
    }

    HttpSession getHttpSession(String id) {
        HttpSession s = (HttpSession)this._sessions.get(id);
        return s;
    }

    public synchronized HttpSession newSession() {
        Session session = new Session();
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        this._sessions.put(session.getId(), session);
        return session;
    }

    public static void access(HttpSession session) {
        ((Session)session).accessed();
    }

    public static boolean isValid(HttpSession session) {
        return !((Session)session).invalid;
    }

    public synchronized void setSessionTimeout(int timeoutMinutes) {
        this._dftMaxIdleSecs = timeoutMinutes * 60;
        this._scavengeDelay = this._dftMaxIdleSecs * 250;
        if (this._scavengeDelay > 60000) {
            this._scavengeDelay = 60000;
        }
        if (this._scavenger == null && this._scavengeDelay > 0) {
            this._scavenger = new SessionScavenger();
        }
    }

    public void stop() {
        ArrayList sessions = new ArrayList(this._sessions.values());
        Iterator i = ((AbstractList)sessions).iterator();
        while (i.hasNext()) {
            Session session = (Session)i.next();
            session.invalidate();
        }
        if (this._scavenger != null) {
            this._scavenger.interrupt();
        }
        this._scavenger = null;
    }

    private void scavenge() {
        long now = System.currentTimeMillis();
        ArrayList<Session> staleSessions = null;
        try {
            Iterator i = this._sessions.values().iterator();
            while (i.hasNext()) {
                Session session = (Session)i.next();
                long idleTime = session.maxIdleMillis;
                if (idleTime <= 0L || session.accessed + idleTime >= now) continue;
                if (staleSessions == null) {
                    staleSessions = new ArrayList<Session>(5);
                }
                staleSessions.add(session);
            }
        }
        catch (ConcurrentModificationException e) {
            Code.ignore(e);
            int oldPriority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                Context context = this;
                synchronized (context) {
                    staleSessions = null;
                    this.scavenge();
                }
                Object var7_11 = null;
                Thread.currentThread().setPriority(oldPriority);
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                Thread.currentThread().setPriority(oldPriority);
                throw throwable;
            }
        }
        if (staleSessions != null) {
            int i = staleSessions.size() - 1;
            while (i >= 0) {
                ((Session)staleSessions.get(i)).invalidate();
                --i;
            }
        }
    }

    public String toString() {
        return "Servlet" + this._handlerContext.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Context(ServletHandler handler) {
        this._handler = handler;
        this._handlerContext = this._handler.getHandlerContext();
        if (this._handlerContext != null) {
            this._logSink = (LogSink)this._handlerContext.getAttribute(CONTEXT_LOG);
        }
    }

    class SessionScavenger
    extends Thread {
        public void run() {
            while (Context.this._scavengeDelay > 0) {
                try {
                    Thread.sleep(Context.this._scavengeDelay);
                    Context.this.scavenge();
                }
                catch (InterruptedException ex) {
                    break;
                }
                catch (Exception ex) {
                    Code.warning(ex);
                }
            }
        }

        SessionScavenger() {
            super("SessionScavenger");
            this.setDaemon(true);
            this.start();
        }
    }

    class Session
    implements HttpSession {
        HashMap _values = new HashMap(11);
        boolean invalid = false;
        boolean newSession = true;
        long created;
        long accessed = this.created = System.currentTimeMillis();
        long maxIdleMillis = -1L;
        String id = null;

        void accessed() {
            this.newSession = false;
            this.accessed = System.currentTimeMillis();
        }

        public String getId() throws IllegalStateException {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return this.id;
        }

        public long getCreationTime() throws IllegalStateException {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return this.created;
        }

        public long getLastAccessedTime() throws IllegalStateException {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return this.accessed;
        }

        public int getMaxInactiveInterval() {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return (int)(this.maxIdleMillis / 1000L);
        }

        public HttpSessionContext getSessionContext() throws IllegalStateException {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return Context.this;
        }

        public void setMaxInactiveInterval(int secs) {
            this.maxIdleMillis = (long)secs * 1000L;
            if (this.maxIdleMillis > 0L && this.maxIdleMillis / 4L < (long)Context.this._scavengeDelay) {
                Context context = Context.this;
                synchronized (context) {
                    Context.this._scavengeDelay = Context.this._dftMaxIdleSecs * 250;
                    if (Context.this._scavengeDelay > 60000) {
                        Context.this._scavengeDelay = 60000;
                    }
                    if (Context.this._scavenger == null && Context.this._scavengeDelay > 0) {
                        Context context2 = Context.this;
                        if (context2 == null) {
                            throw null;
                        }
                        Context.this._scavenger = context2.new SessionScavenger();
                    }
                }
            }
        }

        public synchronized void invalidate() throws IllegalStateException {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            Iterator iter = this._values.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = this._values.get(key);
                iter.remove();
                this.unbindValue(key, value);
            }
            Context context = Context.this;
            synchronized (context) {
                Context.this._sessions.remove(this.id);
            }
            this.invalid = true;
        }

        public boolean isNew() throws IllegalStateException {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return this.newSession;
        }

        public Object getAttribute(String name) {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return this._values.get(name);
        }

        public Enumeration getAttributeNames() {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            return Collections.enumeration(this._values.keySet());
        }

        public void setAttribute(String name, Object value) {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            Object oldValue = this._values.put(name, value);
            if (value != oldValue) {
                this.unbindValue(name, oldValue);
                this.bindValue(name, value);
            }
        }

        public void removeAttribute(String name) {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            Object value = this._values.remove(name);
            this.unbindValue(name, value);
        }

        public Object getValue(String name) throws IllegalStateException {
            return this.getAttribute(name);
        }

        public synchronized String[] getValueNames() throws IllegalStateException {
            if (this.invalid) {
                throw new IllegalStateException();
            }
            String[] a = new String[this._values.size()];
            return this._values.keySet().toArray(a);
        }

        public void putValue(String name, Object value) throws IllegalStateException {
            this.setAttribute(name, value);
        }

        public void removeValue(String name) throws IllegalStateException {
            this.removeAttribute(name);
        }

        private void bindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        private void unbindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        Session() {
            Class clazz;
            if (class$Lorg$mortbay$jetty$servlet$Context != null) {
                clazz = class$Lorg$mortbay$jetty$servlet$Context;
            } else {
                Class clazz2 = Context.class$("org.mortbay.jetty.servlet.Context");
                clazz = clazz2;
                class$Lorg$mortbay$jetty$servlet$Context = clazz2;
            }
            Class clazz3 = clazz;
            synchronized (clazz3) {
                do {
                    long newId = __nextSessionId;
                    __nextSessionId = __nextSessionId + (long)this.hashCode();
                    if (newId < 0L) {
                        newId = -newId;
                    }
                    this.id = Long.toString(newId, 30 + (int)(this.created % 7L));
                } while (Context.this._sessions.containsKey(this.id));
            }
            if (Context.this._dftMaxIdleSecs >= 0) {
                this.maxIdleMillis = Context.this._dftMaxIdleSecs * 1000;
            }
        }
    }
}

