/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import org.mortbay.http.HandlerContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.util.Code;
import org.mortbay.util.Log;

public abstract class NullHandler
implements HttpHandler {
    private boolean _started = false;
    private boolean _destroyed = true;
    private HandlerContext _context;
    private String _name;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        if (this._name == null) {
            this._name = this.getClass().getName();
            if (!Code.debug()) {
                this._name = this._name.substring(this._name.lastIndexOf(46) + 1);
            }
        }
        return this._name;
    }

    public HandlerContext getHandlerContext() {
        return this._context;
    }

    public void initialize(HandlerContext context) {
        if (this._context == null) {
            this._context = context;
        } else if (this._context != context) {
            throw new IllegalStateException("Can't initialize handler for different context");
        }
    }

    public void start() throws Exception {
        if (this._context == null) {
            throw new IllegalStateException("No context for " + this);
        }
        if (!this._context.isStarted()) {
            Code.warning("Handler Context not started for " + this);
        }
        this._started = true;
        this._destroyed = false;
        Log.event("Started " + this);
    }

    public void stop() {
        this._started = false;
        Log.event("Stopped " + this);
    }

    public void destroy() {
        this._started = false;
        this._destroyed = true;
        this._context = null;
        Log.event("Destroyed " + this);
    }

    public boolean isStarted() {
        return this._started;
    }

    public boolean isDestroyed() {
        return this._destroyed;
    }

    public String toString() {
        return this.getName() + " in " + this._context;
    }

    public abstract void handle(String var1, String var2, HttpRequest var3, HttpResponse var4) throws HttpException, IOException;
}

