/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.mortbay.http.ChunkableOutputStream;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.NullHandler;
import org.mortbay.util.Code;
import org.mortbay.util.StringUtil;

public class NotFoundHandler
extends NullHandler {
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        Code.debug("Not Found");
        String method = request.getMethod();
        if (method.equals("GET")) {
            response.sendError(HttpResponse.__404_Not_Found, "Could not find resource for " + request.getPath());
        } else if (method.equals("HEAD") || method.equals("POST") || method.equals("PUT") || method.equals("DELETE") || method.equals("MOVE")) {
            response.sendError(HttpResponse.__404_Not_Found);
        } else if (method.equals("OPTIONS")) {
            if ("*".equals(request.getPath())) {
                response.setIntField("Content-Length", 0);
                response.setField("Allow", "GET, HEAD, POST, PUT, DELETE, MOVE, OPTIONS, TRACE");
                response.sendError(HttpResponse.__200_OK);
            } else {
                response.sendError(HttpResponse.__404_Not_Found);
            }
        } else if (method.equals("TRACE")) {
            response.setField("Content-Type", "message/http");
            ChunkableOutputStream out = response.getOutputStream();
            ByteArrayOutputStream buf = new ByteArrayOutputStream(2048);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, StringUtil.__ISO_8859_1);
            writer.write(request.toString());
            ((Writer)writer).flush();
            response.setIntField("Content-Length", buf.size());
            buf.writeTo(out);
            request.setHandled(true);
        } else {
            response.setField("Allow", "GET, HEAD, POST, PUT, DELETE, MOVE, OPTIONS, TRACE");
            response.sendError(HttpResponse.__405_Method_Not_Allowed);
        }
    }
}

