/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.net.Socket;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpServer;
import org.mortbay.util.Code;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Log;
import org.mortbay.util.ThreadedServer;

public class SocketListener
extends ThreadedServer
implements HttpListener {
    private HttpServer _server;
    private int _lowResourcePersistTimeMs = 2000;
    private int _throttled = 0;
    private boolean _lastLow = false;
    private boolean _lastOut = false;
    private String _scheme = "http";

    public void setHttpServer(HttpServer server) {
        Code.assert(this._server == null || this._server == server, "Cannot share listeners");
        this._server = server;
    }

    public HttpServer getHttpServer() {
        return this._server;
    }

    public void setDefaultScheme(String scheme) {
        this._scheme = scheme;
    }

    public String getDefaultScheme() {
        return this._scheme;
    }

    public int getLowResourcePersistTimeMs() {
        return this._lowResourcePersistTimeMs;
    }

    public void setLowResourcePersistTimeMs(int ms) {
        this._lowResourcePersistTimeMs = ms;
    }

    public void start() throws Exception {
        super.start();
        Log.event("Started SocketListener on " + this.getInetAddrPort());
    }

    public void stop() throws InterruptedException {
        super.stop();
        Log.event("Stopped SocketListener on " + this.getInetAddrPort());
    }

    public void destroy() {
        Log.event("Destroy SocketListener on " + this.getInetAddrPort());
        super.destroy();
        if (this._server != null) {
            this._server.removeListener(this);
        }
        this._server = null;
    }

    public void handleConnection(Socket socket) throws IOException {
        HttpConnection connection = new HttpConnection(this, socket.getInetAddress(), socket.getInputStream(), socket.getOutputStream(), socket);
        try {
            if (this._lowResourcePersistTimeMs > 0 && this.isLowOnResources()) {
                ++this._throttled;
                socket.setSoTimeout(this._lowResourcePersistTimeMs);
            } else {
                socket.setSoTimeout(this.getMaxIdleTimeMs());
            }
        }
        catch (Exception e) {
            Code.warning(e);
        }
        connection.handle();
    }

    public void customizeRequest(HttpConnection connection, HttpRequest request) {
        Socket socket = (Socket)connection.getConnection();
        this.customizeRequest(socket, request);
    }

    protected void customizeRequest(Socket socket, HttpRequest request) {
        try {
            if (socket.getSoTimeout() != this.getMaxReadTimeMs()) {
                if (this._throttled > 0) {
                    --this._throttled;
                }
                socket.setSoTimeout(this.getMaxReadTimeMs());
            }
        }
        catch (Exception e) {
            Code.ignore(e);
        }
    }

    public void persistConnection(HttpConnection connection) {
        try {
            if (this._lowResourcePersistTimeMs > 0 && this.isLowOnResources()) {
                ++this._throttled;
                Socket socket = (Socket)connection.getConnection();
                socket.setSoTimeout(this._lowResourcePersistTimeMs);
            } else {
                Socket socket = (Socket)connection.getConnection();
                socket.setSoTimeout(this.getMaxIdleTimeMs());
            }
        }
        catch (Exception e) {
            Code.ignore(e);
        }
    }

    public boolean isLowOnResources() {
        boolean low;
        boolean bl = low = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() < this.getMinThreads();
        if (low && !this._lastLow) {
            Log.event("LOW ON THREADS: " + this);
        } else if (!low && this._lastLow) {
            Log.event("OK on threads: " + this);
            this._lastOut = false;
        }
        this._lastLow = low;
        return low;
    }

    public boolean isOutOfResources() {
        boolean out;
        boolean bl = out = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() == 0;
        if (out && !this._lastOut) {
            Code.warning("OUT OF THREADS: " + this);
        }
        this._lastOut = out;
        return out;
    }

    public SocketListener() {
    }

    public SocketListener(InetAddrPort address) throws IOException {
        super(address);
    }
}

