/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.util.TimeZone;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.RequestLogFormat;
import org.mortbay.util.DateCache;

public class NCSARequestLogFormat
implements RequestLogFormat {
    private DateCache _logDateCache;
    private boolean _extended;

    public String format(HttpRequest request, HttpResponse response, int responseLength) {
        StringBuffer buf;
        StringBuffer stringBuffer = buf = new StringBuffer(256);
        synchronized (stringBuffer) {
            buf.append(request.getRemoteAddr());
            buf.append(" - ");
            String user = (String)request.getAttribute("org.mortbay.http.HttpRequest.AuthUser");
            buf.append(user == null ? "-" : user);
            buf.append(" [");
            this._logDateCache.format(System.currentTimeMillis(), buf);
            buf.append("] \"");
            request.appendRequestLine(buf);
            buf.append("\" ");
            buf.append(response.getStatus());
            if (responseLength >= 0) {
                buf.append(' ');
                buf.append(responseLength);
                buf.append(' ');
            } else {
                buf.append(" - ");
            }
            if (this._extended) {
                String referer = request.getField("Referer");
                if (referer == null) {
                    buf.append("- ");
                } else {
                    buf.append('\"');
                    buf.append(referer);
                    buf.append("\" ");
                }
                String agent = request.getField("User-Agent");
                if (agent == null) {
                    buf.append('-');
                } else {
                    buf.append('\"');
                    buf.append(agent);
                    buf.append('\"');
                }
            }
            String string = buf.toString();
            Object var6_10 = null;
            return string;
        }
    }

    public NCSARequestLogFormat() {
        this("dd/MMM/yyyy:HH:mm:ss ZZZ", TimeZone.getDefault().getID(), true);
    }

    public NCSARequestLogFormat(String logDateFormat, String timeZoneID, boolean extended) {
        this._logDateCache = new DateCache(logDateFormat);
        this._logDateCache.setTimeZoneID(timeZoneID);
        this._extended = extended;
    }
}

