/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.OutputStream;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;

public class MultiPartResponse {
    private static final byte[] __CRLF = "\r\n".getBytes();
    private static final byte[] __DASHDASH = "--".getBytes();
    private String boundary = "org.mortbay.http.MultiPartResponse.boundary." + Long.toString(System.currentTimeMillis(), 36);
    private byte[] boundaryBytes = this.boundary.getBytes();
    private OutputStream out = null;
    private boolean inPart = false;

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void startPart(String contentType) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-type: " + contentType).getBytes());
        this.out.write(__CRLF);
        this.out.write(__CRLF);
    }

    public void startPart(String contentType, String[] headers) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-type: " + contentType).getBytes());
        this.out.write(__CRLF);
        int i = 0;
        while (headers != null && i < headers.length) {
            this.out.write(headers[i].getBytes());
            this.out.write(__CRLF);
            ++i;
        }
        this.out.write(__CRLF);
    }

    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__DASHDASH);
        this.out.write(__CRLF);
        this.inPart = false;
    }

    protected MultiPartResponse(OutputStream out) throws IOException {
        this.out = out;
        this.inPart = false;
    }

    public MultiPartResponse(HttpRequest request, HttpResponse response) throws IOException {
        response.setField("Content-Type", "multipart/mixed;boundary=" + this.boundary);
        this.out = response.getOutputStream();
        this.inPart = false;
    }
}

