/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.mortbay.http.HandlerContext;
import org.mortbay.http.HttpEncoding;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.NCSARequestLogFormat;
import org.mortbay.http.PathMap;
import org.mortbay.http.RequestLogFormat;
import org.mortbay.http.SocketListener;
import org.mortbay.http.UserRealm;
import org.mortbay.http.Version;
import org.mortbay.http.handler.DumpHandler;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.util.Code;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.Log;
import org.mortbay.util.LogSink;
import org.mortbay.util.MultiException;
import org.mortbay.util.StringMap;
import org.mortbay.util.URI;

public class HttpServer
extends BeanContextSupport
implements LifeCycle {
    private static ArrayList __servers = new ArrayList(3);
    private static List __roServers = Collections.unmodifiableList(__servers);
    private HashMap _listeners = new HashMap(3);
    private HttpEncoding _httpEncoding;
    private HashMap _realmMap = new HashMap(3);
    private StringMap _hostMap = new StringMap();
    private HandlerContext _notFoundContext = null;
    private boolean _chunkingForced = false;
    private LogSink _requestLogSink;
    private RequestLogFormat _requestLogFormat;
    private boolean _statsOn = false;
    private int _connections;
    private int _connectionsOpen;
    private int _connectionsOpenMax;
    private long _connectionsDurationAve;
    private long _connectionsDurationMax;
    private int _connectionsRequestsAve;
    private int _connectionsRequestsMax;
    private int _errors;
    private int _requests;
    private int _requestsActive;
    private int _requestsActiveMax;
    private long _requestsDurationAve;
    private long _requestsDurationMax;

    public HttpEncoding getHttpEncoding() {
        if (this._httpEncoding == null) {
            this._httpEncoding = new HttpEncoding();
        }
        return this._httpEncoding;
    }

    public void setHttpEncoding(HttpEncoding httpEncoding) {
        this._httpEncoding = httpEncoding;
    }

    public synchronized void start() throws MultiException {
        Log.event("Starting " + Version.__VersionImpl);
        MultiException mex = new MultiException();
        if (Code.verbose(99)) {
            Code.debug((Object)"LISTENERS: ", (Object)this._listeners);
            Code.debug((Object)"HANDLER: ", (Object)this._hostMap);
        }
        if (this._requestLogSink != null) {
            if (!this._requestLogSink.isStarted()) {
                try {
                    this._requestLogSink.start();
                    Log.event("Started " + this._requestLogSink);
                }
                catch (Exception e) {
                    mex.add(e);
                }
            }
            if (this._requestLogFormat == null) {
                String logDateFormat = "dd/MMM/yyyy:HH:mm:ss ZZZ";
                try {
                    Method gldf = this._requestLogSink.getClass().getMethod("getLogDateFormat", null);
                    logDateFormat = (String)gldf.invoke((Object)this._requestLogSink, null);
                }
                catch (Exception e) {
                    Code.ignore(e);
                }
                this._requestLogFormat = new NCSARequestLogFormat(logDateFormat, TimeZone.getDefault().getID(), true);
            }
        }
        Iterator contexts = this.getHandlerContexts().iterator();
        while (contexts.hasNext()) {
            HandlerContext context = (HandlerContext)contexts.next();
            if (context.isStarted()) continue;
            try {
                context.start();
            }
            catch (Exception e) {
                mex.add(e);
            }
        }
        Iterator listeners = this.getListeners().iterator();
        while (listeners.hasNext()) {
            HttpListener listener = (HttpListener)listeners.next();
            listener.setHttpServer(this);
            if (listener.isStarted()) continue;
            try {
                listener.start();
            }
            catch (Exception e) {
                mex.add(e);
            }
        }
        Log.event("Started " + this);
        mex.ifExceptionThrowMulti();
    }

    public synchronized boolean isStarted() {
        if (this._requestLogSink != null && this._requestLogSink.isStarted()) {
            return true;
        }
        Iterator listeners = this.getListeners().iterator();
        while (listeners.hasNext()) {
            HttpListener listener = (HttpListener)listeners.next();
            if (!listener.isStarted()) continue;
            return true;
        }
        Iterator contexts = this.getHandlerContexts().iterator();
        while (contexts.hasNext()) {
            HandlerContext context = (HandlerContext)contexts.next();
            if (!context.isStarted()) continue;
            return true;
        }
        return false;
    }

    public synchronized void stop() throws InterruptedException {
        Iterator listeners = this.getListeners().iterator();
        while (listeners.hasNext()) {
            HttpListener listener = (HttpListener)listeners.next();
            if (!listener.isStarted()) continue;
            try {
                listener.stop();
            }
            catch (Exception e) {
                if (Code.debug()) {
                    Code.warning(e);
                    continue;
                }
                Code.warning(e.toString());
            }
        }
        Iterator contexts = this.getHandlerContexts().iterator();
        while (contexts.hasNext()) {
            HandlerContext context = (HandlerContext)contexts.next();
            if (!context.isStarted()) continue;
            context.stop();
        }
        if (this._requestLogSink != null) {
            this._requestLogSink.stop();
            Log.event("Stopped " + this._requestLogSink);
        }
        Log.event("Stopped " + this);
    }

    public synchronized void destroy() {
        ((AbstractCollection)__servers).remove(this);
        Iterator listeners = this.getListeners().iterator();
        while (listeners.hasNext()) {
            HttpListener listener = (HttpListener)listeners.next();
            try {
                listener.destroy();
            }
            catch (Exception e) {
                Code.warning(e);
            }
        }
        Iterator contexts = this.getHandlerContexts().iterator();
        while (contexts.hasNext()) {
            HandlerContext context = (HandlerContext)contexts.next();
            try {
                context.destroy();
            }
            catch (Exception e) {
                Code.warning(e);
            }
        }
        if (this._hostMap == null) {
            Code.warning("HttpServer.destroy() on an already destroyed HttpServer.");
        } else {
            this._hostMap.clear();
            this._hostMap = null;
        }
        if (this._listeners != null) {
            this._listeners.clear();
            this._listeners = null;
        }
        if (this._requestLogSink != null) {
            this.remove(this._requestLogSink);
            this._requestLogSink.destroy();
        }
    }

    public synchronized boolean isDestroyed() {
        return this._hostMap == null;
    }

    public HttpListener addListener(InetAddrPort address) throws IOException {
        HttpListener listener = (HttpListener)this._listeners.get(address);
        if (listener == null) {
            listener = new SocketListener(address);
            listener.setHttpServer(this);
            this._listeners.put(address, listener);
        }
        this.add(listener);
        return listener;
    }

    public void addListener(HttpListener listener) throws IllegalArgumentException {
        listener.setHttpServer(this);
        this._listeners.put(listener, listener);
        this.add(listener);
    }

    public HttpListener addListener(String listenerClass) throws IllegalArgumentException {
        try {
            if (listenerClass == null || listenerClass.length() == 0) {
                listenerClass = "org.mortbay.http.SocketListener";
            }
            Class<?> lc = Class.forName(listenerClass);
            HttpListener listener = (HttpListener)lc.newInstance();
            listener.setHttpServer(this);
            this._listeners.put(listener, listener);
            this.add(listener);
            return listener;
        }
        catch (Exception e) {
            Code.warning(e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public void removeListener(HttpListener listener) {
        Iterator iterator = this._listeners.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != listener) continue;
            iterator.remove();
            this.remove(listener);
        }
    }

    public Collection getListeners() {
        if (this._listeners == null) {
            return Collections.EMPTY_LIST;
        }
        return this._listeners.values();
    }

    public void addHostAlias(String host, String alias) {
        Object contextMap = this._hostMap.get(host);
        if (contextMap == null) {
            throw new IllegalArgumentException("No Such Host: " + host);
        }
        this._hostMap.put(alias, contextMap);
    }

    protected HandlerContext newHandlerContext(String contextPathSpec) {
        return new HandlerContext(this, contextPathSpec);
    }

    public HandlerContext addContext(String contextPath) {
        return this.addContext(null, contextPath);
    }

    public HandlerContext addContext(String host, String contextPathSpec) {
        if (host != null && host.length() == 0) {
            host = null;
        }
        HandlerContext hc = this.newHandlerContext(contextPathSpec);
        this.addContext(host, hc);
        return hc;
    }

    public void addContext(String host, HandlerContext context) {
        ArrayList<HandlerContext> contextList;
        String contextPathSpec;
        PathMap contextMap = (PathMap)this._hostMap.get(host);
        if (contextMap == null) {
            contextMap = new PathMap(7);
            this._hostMap.put(host, (Object)contextMap);
        }
        if ((contextPathSpec = context.getContextPath()).length() > 1) {
            contextPathSpec = contextPathSpec + "/*";
        }
        if ((contextList = (ArrayList<HandlerContext>)contextMap.get(contextPathSpec)) == null) {
            contextList = new ArrayList<HandlerContext>(1);
            contextMap.put(contextPathSpec, contextList);
        }
        contextList.add(context);
        context.addHost(host);
        this.add(context);
        Code.debug((Object)"Added ", context, (Object)" for host ", host);
    }

    public void removeContext(String host, String contextPathSpec, int i) throws IllegalStateException {
        PathMap contextMap = (PathMap)this._hostMap.get(host);
        if (contextMap != null) {
            List contextList = (List)contextMap.get(contextPathSpec);
            if (contextList != null && i < contextList.size()) {
                HandlerContext hc = (HandlerContext)contextList.get(i);
                if (hc != null && hc.isStarted()) {
                    throw new IllegalStateException("Context not stopped");
                }
                this.remove(hc);
                contextList.remove(i);
            }
            if (contextList.size() == 0) {
                contextMap.remove(contextPathSpec);
            }
        }
    }

    public void removeContext(HandlerContext context) throws IllegalStateException {
        if (context.isStarted()) {
            throw new IllegalStateException("Context not stopped");
        }
        Iterator i1 = this._hostMap.values().iterator();
        while (i1.hasNext()) {
            PathMap contextMap = (PathMap)i1.next();
            Iterator i2 = contextMap.values().iterator();
            while (i2.hasNext()) {
                List contextList = (List)i2.next();
                if (contextList.remove(context)) {
                    this.remove(context);
                }
                if (contextList.size() != 0) continue;
                i2.remove();
            }
        }
    }

    public HandlerContext getContext(String host, String contextPathSpec, int i) {
        List contextList;
        HandlerContext hc = null;
        PathMap contextMap = (PathMap)this._hostMap.get(host);
        if (contextMap != null && (contextList = (List)contextMap.get(contextPathSpec)) != null) {
            if (i >= contextList.size()) {
                return null;
            }
            hc = (HandlerContext)contextList.get(i);
        }
        return hc;
    }

    public HandlerContext getContext(String host, String contextPath) {
        List contextList;
        HandlerContext hc = null;
        PathMap contextMap = (PathMap)this._hostMap.get(host);
        if (contextMap != null && (contextList = (List)contextMap.get(contextPath)) != null && contextList.size() > 0) {
            hc = (HandlerContext)contextList.get(contextList.size() - 1);
        }
        if (hc == null) {
            hc = this.addContext(host, contextPath);
        }
        return hc;
    }

    public synchronized Set getHandlers() {
        HashSet set = new HashSet(33);
        Iterator maps = this._hostMap.values().iterator();
        while (maps.hasNext()) {
            PathMap pm = (PathMap)maps.next();
            Iterator lists = pm.values().iterator();
            while (lists.hasNext()) {
                List list = (List)lists.next();
                Iterator contexts = list.iterator();
                while (contexts.hasNext()) {
                    HandlerContext context = (HandlerContext)contexts.next();
                    set.addAll(context.getHandlers());
                }
            }
        }
        return set;
    }

    public synchronized Set getHandlerContexts() {
        if (this._hostMap == null) {
            return Collections.EMPTY_SET;
        }
        HashSet set = new HashSet(33);
        Iterator maps = this._hostMap.values().iterator();
        while (maps.hasNext()) {
            PathMap pm = (PathMap)maps.next();
            Iterator lists = pm.values().iterator();
            while (lists.hasNext()) {
                List list = (List)lists.next();
                set.addAll(list);
            }
        }
        return set;
    }

    public synchronized LogSink getLogSink() {
        return this.getRequestLogSink();
    }

    public synchronized void setLogSink(LogSink logSink) {
        this.setRequestLogSink(logSink);
    }

    public synchronized LogSink getRequestLogSink() {
        return this._requestLogSink;
    }

    public synchronized void setRequestLogSink(LogSink logSink) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._requestLogSink != null) {
            this.remove(this._requestLogSink);
        }
        this._requestLogSink = logSink;
        if (this._requestLogSink != null) {
            this.add(this._requestLogSink);
        }
    }

    public RequestLogFormat getRequestLogFormat() {
        return this._requestLogFormat;
    }

    public void setRequestLogFormat(RequestLogFormat format) {
        this._requestLogFormat = format;
    }

    void log(HttpRequest request, HttpResponse response, int length) {
        if (this._requestLogSink != null && this._requestLogFormat != null && request != null && response != null) {
            this._requestLogSink.log(this._requestLogFormat.format(request, response, length));
        }
    }

    public HandlerContext service(HttpRequest request, HttpResponse response) throws IOException, HttpException {
        String host = request.getHost();
        while (true) {
            List contextLists;
            PathMap contextMap;
            if ((contextMap = (PathMap)this._hostMap.get(host)) != null && (contextLists = contextMap.getMatches(request.getPath())) != null) {
                if (Code.verbose(99)) {
                    Code.debug((Object)"Contexts at ", request.getPath(), (Object)": ", contextLists);
                }
                int i = 0;
                while (i < contextLists.size()) {
                    Map.Entry entry = (Map.Entry)contextLists.get(i);
                    List contextList = (List)entry.getValue();
                    int j = 0;
                    while (j < contextList.size()) {
                        HandlerContext context = (HandlerContext)contextList.get(j);
                        if (Code.debug()) {
                            Code.debug((Object)"Try ", context, (Object)",", new Integer(j));
                        }
                        if (context.handle(request, response)) {
                            return context;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (host == null) break;
            host = null;
        }
        HttpServer httpServer = this;
        synchronized (httpServer) {
            if (this._notFoundContext == null) {
                this._notFoundContext = new HandlerContext(this, "/");
                this._notFoundContext.addHandler(new NotFoundHandler());
                try {
                    this._notFoundContext.start();
                }
                catch (Exception e) {
                    Code.warning(e);
                }
            }
            if (!this._notFoundContext.handle(request, response)) {
                response.sendError(HttpResponse.__404_Not_Found);
            }
            HandlerContext handlerContext = this._notFoundContext;
            Object var5_5 = null;
            return handlerContext;
        }
    }

    public HttpHandler findHandler(Class handlerClass, String uri, List hosts) {
        uri = URI.stripPath(uri);
        int h = 0;
        while (h < hosts.size()) {
            List contextLists;
            String host = (String)hosts.get(h);
            PathMap contextMap = (PathMap)this._hostMap.get(host);
            if (contextMap != null && (contextLists = contextMap.getMatches(uri)) != null) {
                int i = 0;
                while (i < contextLists.size()) {
                    Map.Entry entry = (Map.Entry)contextLists.get(i);
                    String contextPath = (String)entry.getKey();
                    List contextList = (List)entry.getValue();
                    int j = 0;
                    while (j < contextList.size()) {
                        HandlerContext context = (HandlerContext)contextList.get(j);
                        HttpHandler handler = context.getHandler(handlerClass);
                        if (handler != null) {
                            return handler;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            ++h;
        }
        return null;
    }

    public UserRealm addRealm(UserRealm realm) {
        return this._realmMap.put(realm.getName(), realm);
    }

    public UserRealm getRealm(String realmName) {
        return (UserRealm)this._realmMap.get(realmName);
    }

    public UserRealm removeRealm(String realmName) {
        return (UserRealm)this._realmMap.remove(realmName);
    }

    public boolean isChunkingForced() {
        return this._chunkingForced;
    }

    public void setChunkingForced(boolean forced) {
        this._chunkingForced = forced;
    }

    public static List getHttpServerList() {
        return __roServers;
    }

    public Map getHostMap() {
        return this._hostMap;
    }

    public void statsReset() {
        this._connections = 0;
        this._connectionsOpen = 0;
        this._connectionsOpenMax = 0;
        this._connectionsDurationAve = 0L;
        this._connectionsDurationMax = 0L;
        this._connectionsRequestsAve = 0;
        this._connectionsRequestsMax = 0;
        this._errors = 0;
        this._requests = 0;
        this._requestsActive = 0;
        this._requestsActiveMax = 0;
        this._requestsDurationAve = 0L;
        this._requestsDurationMax = 0L;
    }

    public void setStatsOn(boolean on) {
        Log.event("Statistics on = " + on + " for " + this);
        this._statsOn = on;
    }

    public boolean getStatsOn() {
        return this._statsOn;
    }

    public int getConnections() {
        return this._connections;
    }

    public int getConnectionsOpen() {
        return this._connectionsOpen;
    }

    public int getConnectionsOpenMax() {
        return this._connectionsOpenMax;
    }

    public long getConnectionsDurationAve() {
        return this._connectionsDurationAve / 128L;
    }

    public long getConnectionsDurationMax() {
        return this._connectionsDurationMax;
    }

    public int getConnectionsRequestsAve() {
        return this._connectionsRequestsAve / 16;
    }

    public int getConnectionsRequestsMax() {
        return this._connectionsRequestsMax;
    }

    public int getErrors() {
        return this._errors;
    }

    public int getRequests() {
        return this._requests;
    }

    public int getRequestsActive() {
        return this._requestsActive;
    }

    public int getRequestsActiveMax() {
        return this._requestsActiveMax;
    }

    public long getRequestsDurationAve() {
        return this._requestsDurationAve / 128L;
    }

    public long getRequestsDurationMax() {
        return this._requestsDurationMax;
    }

    synchronized void statsOpenConnection() {
        if (++this._connectionsOpen > this._connectionsOpenMax) {
            this._connectionsOpenMax = this._connectionsOpen;
        }
    }

    synchronized void statsGotRequest() {
        if (++this._requestsActive > this._requestsActiveMax) {
            this._requestsActiveMax = this._requestsActive;
        }
    }

    synchronized void statsEndRequest(long duration, boolean ok) {
        ++this._requests;
        if (!ok) {
            ++this._errors;
        }
        --this._requestsActive;
        if (this._requestsActive < 0) {
            this._requestsActive = 0;
        }
        if (duration > this._requestsDurationMax) {
            this._requestsDurationMax = duration;
        }
        if (this._requestsDurationAve == 0L) {
            this._requestsDurationAve = duration * 128L;
        }
        this._requestsDurationAve = this._requestsDurationAve - this._requestsDurationAve / 128L + duration;
    }

    synchronized void statsCloseConnection(long duration, int requests) {
        ++this._connections;
        --this._connectionsOpen;
        if (this._connectionsOpen < 0) {
            this._connectionsOpen = 0;
        }
        if (duration > this._connectionsDurationMax) {
            this._connectionsDurationMax = duration;
        }
        if (this._connectionsDurationAve == 0L) {
            this._connectionsDurationAve = 128L * duration;
        }
        this._connectionsDurationAve = this._connectionsDurationAve - this._connectionsDurationAve / 128L + duration;
        if (requests > this._connectionsRequestsMax) {
            this._connectionsRequestsMax = requests;
        }
        if (this._connectionsRequestsAve == 0) {
            this._connectionsRequestsAve = 16;
        }
        this._connectionsRequestsAve = this._connectionsRequestsAve - this._connectionsRequestsAve / 16 + requests;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"8080"};
        } else if (args.length == 1 && args[0].startsWith("-")) {
            System.err.println("\nUsage - java org.mortbay.http.HttpServer [[<addr>:]<port> .. ]");
            System.err.println("\n  Serves files from 'docroot' directory");
            System.err.println("\n  Default port is 8080");
            System.exit(1);
        }
        try {
            HttpServer server = new HttpServer();
            String host = null;
            HandlerContext context = server.getContext(host, "/");
            context.setResourceBase("docroot/");
            context.setServingResources(true);
            context.addHandler(new DumpHandler());
            int i = 0;
            while (i < args.length) {
                InetAddrPort address = new InetAddrPort(args[i]);
                server.addListener(address);
                ++i;
            }
            server.start();
        }
        catch (Exception e) {
            Code.warning(e);
        }
    }

    public HttpServer() {
        __servers.add(this);
        this._hostMap.setIgnoreCase(true);
    }
}

