/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import org.mortbay.http.ChunkableInputStream;
import org.mortbay.http.ChunkableOutputStream;
import org.mortbay.http.HandlerContext;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpMessage;
import org.mortbay.http.HttpRequest;
import org.mortbay.util.Code;
import org.mortbay.util.StringUtil;

public class HttpResponse
extends HttpMessage {
    public static final int __100_Continue = 100;
    public static final int __101_Switching_Protocols = 101;
    public static final int __200_OK = 200;
    public static final int __201_Created = 201;
    public static final int __202_Accepted = 202;
    public static final int __203_Non_Authoritative_Information = 203;
    public static final int __204_No_Content = 204;
    public static final int __205_Reset_Content = 205;
    public static final int __206_Partial_Content = 206;
    public static final int __300_Multiple_Choices = 300;
    public static final int __301_Moved_Permanently = 301;
    public static final int __302_Moved_Temporarily = 302;
    public static final int __303_See_Other = 303;
    public static final int __304_Not_Modified = 304;
    public static final int __305_Use_Proxy = 305;
    public static final int __400_Bad_Request = 400;
    public static final int __401_Unauthorized = 401;
    public static final int __402_Payment_Required = 402;
    public static final int __403_Forbidden = 403;
    public static final int __404_Not_Found = 404;
    public static final int __405_Method_Not_Allowed = 405;
    public static final int __406_Not_Acceptable = 406;
    public static final int __407_Proxy_Authentication_Required = 407;
    public static final int __408_Request_Timeout = 408;
    public static final int __409_Conflict = 409;
    public static final int __410_Gone = 410;
    public static final int __411_Length_Required = 411;
    public static final int __412_Precondition_Failed = 412;
    public static final int __413_Request_Entity_Too_Large = 413;
    public static final int __414_Request_URI_Too_Large = 414;
    public static final int __415_Unsupported_Media_Type = 415;
    public static final int __416_Requested_Range_Not_Satisfiable = 416;
    public static final int __417_Expectation_Failed = 417;
    public static final int __500_Internal_Server_Error = 500;
    public static final int __501_Not_Implemented = 501;
    public static final int __502_Bad_Gateway = 502;
    public static final int __503_Service_Unavailable = 503;
    public static final int __504_Gateway_Timeout = 504;
    public static final int __505_HTTP_Version_Not_Supported = 505;
    public static final HashMap __statusMsg = new HashMap();
    public static final byte[] __Continue;
    private int _status = 200;
    private String _reason;
    private HandlerContext _handlerContext;
    private static /* synthetic */ Class class$Lorg$mortbay$http$HttpResponse;

    public HandlerContext getHandlerContext() {
        return this._handlerContext;
    }

    void setHandlerContext(HandlerContext context) {
        this._handlerContext = context;
    }

    public boolean isDirty() {
        return this._status != 200 || super.isDirty();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed");
        }
        try {
            this.getOutputStream().resetBuffer();
            this._status = 200;
            this._reason = null;
            super.reset();
        }
        catch (Exception e) {
            Code.warning(e);
            throw new IllegalStateException(e.toString());
        }
    }

    public HttpRequest getRequest() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getRequest();
    }

    public void readHeader(ChunkableInputStream in) throws IOException {
        this._state = 1;
        Code.notImplemented();
    }

    public void writeHeader(Writer writer) throws IOException {
        if (this._state != 0) {
            throw new IllegalStateException(HttpMessage.__state[this._state] + " is not EDITABLE");
        }
        if (this._header == null) {
            throw new IllegalStateException("Response is destroyed");
        }
        if (this._dotVersion >= 0) {
            String status = this._status + " ";
            if (Code.verbose()) {
                Code.debug((Object)"writeHeaders: ", (Object)status);
            }
            this._state = 1;
            Writer writer2 = writer;
            synchronized (writer2) {
                writer.write(this._version);
                writer.write(32);
                writer.write(status);
                writer.write(this.getReason());
                writer.write(HttpFields.__CRLF);
                this._header.write(writer);
            }
        }
        this._state = 3;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public String getReason() {
        if (this._reason != null) {
            return this._reason;
        }
        this._reason = (String)__statusMsg.get(new Integer(this._status));
        if (this._reason == null) {
            this._reason = "unknown";
        }
        return this._reason;
    }

    public void setReason(String reason) {
        this._reason = reason;
    }

    protected HttpFields setFields() throws IllegalStateException {
        HttpRequest request;
        if (!this._acceptTrailer && this._state == 3 && this._version.equals("HTTP/1.1") && (request = this._connection.getRequest()) != null) {
            request.getAcceptableTransferCodings();
        }
        return super.setFields();
    }

    private void sendError(int code, Class exClass, String message) throws IOException {
        Integer code_integer = new Integer(code);
        String reason = (String)__statusMsg.get(code_integer);
        HttpRequest request = this.getRequest();
        this.setStatus(code);
        this.setReason(reason);
        if (code != 204 && code != 304 && code != 206 && code >= 200) {
            String error_page = null;
            while (error_page == null && exClass != null) {
                error_page = this._handlerContext.getErrorPage(exClass.getName());
                exClass = exClass.getSuperclass();
            }
            if (error_page == null) {
                error_page = this._handlerContext.getErrorPage("" + code);
            }
            if (error_page != null) {
                if (request.getAttribute("javax.servlet.error.status_code") == null) {
                    request.setAttribute("javax.servlet.error.status_code", code_integer);
                    request.setAttribute("javax.servlet.error.message", message == null ? reason : message);
                    this.getHandlerContext().handle(error_page, null, request, this);
                } else {
                    Code.warning("Error " + code + " while serving error page for " + request.getAttribute("javax.servlet.error.status_code"));
                }
            } else {
                this._header.put("Content-Type", "text/html");
                this._mimeType = "text/html";
                this._characterEncoding = null;
                ChunkableOutputStream out = this.getOutputStream();
                if (message != null) {
                    message = StringUtil.replace(message, "<", "&lt;");
                    message = StringUtil.replace(message, ">", "&gt;");
                }
                String uri = this.getRequest().getPath();
                uri = StringUtil.replace(uri, "<", "&lt;");
                uri = StringUtil.replace(uri, ">", "&gt;");
                StringBuffer body = new StringBuffer(1500);
                body.append("<HTML>\n<HEAD>\n<TITLE>Error ");
                body.append(code);
                body.append(' ');
                body.append(reason);
                body.append("</TITLE>\n<BODY>\n<H2>HTTP ERROR: ");
                body.append(code);
                body.append(' ');
                body.append(reason);
                body.append("</H2>\n");
                if (message != null) {
                    body.append(message);
                }
                body.append("<P>RequestURI=");
                body.append(uri);
                int i = 0;
                while (i < 20) {
                    body.append("\n                                                ");
                    ++i;
                }
                body.append("\n</BODY>\n</HTML>\n");
                byte[] buf = body.toString().getBytes(StringUtil.__ISO_8859_1);
                this._header.putIntField("Content-Length", buf.length);
                out.write(buf);
            }
        } else if (code != 206) {
            this._header.remove("Content-Type");
            this._header.remove("Content-Length");
            this._characterEncoding = null;
            this._mimeType = null;
        }
        if (!this.isCommitted()) {
            this.commitHeader();
        }
    }

    public void sendError(int code, String message) throws IOException {
        this.sendError(code, null, message);
    }

    public void sendError(int code) throws IOException {
        this.sendError(code, null, null);
    }

    public void sendError(int code, Throwable exception) throws IOException {
        if (exception instanceof HttpException) {
            HttpException he = (HttpException)exception;
            code = he.getCode();
            this.sendError(code, null, he.getMessage());
        } else {
            Class<?> exClass = exception.getClass();
            this.getRequest().setAttribute("javax.servlet.error.exception_type", exClass);
            this.sendError(code, exClass, exception.toString());
        }
    }

    public void sendRedirect(String location) throws IOException {
        this._header.put("Location", location);
        this.setStatus(302);
        this.commitHeader();
    }

    public void addSetCookie(String name, String value) {
        this.addSetCookie(new Cookie(name, value), false);
    }

    public void addSetCookie(Cookie cookie) {
        this.addSetCookie(cookie, false);
    }

    public void addSetCookie(Cookie cookie, boolean cookie2) {
        this._header.addSetCookie(cookie, cookie2);
    }

    public void recycle(HttpConnection connection) {
        super.recycle(connection);
        this._status = 200;
        this._version = "HTTP/1.0";
        this._state = 0;
        this._reason = null;
    }

    public void destroy() {
        this._reason = null;
        super.destroy();
    }

    public synchronized void commitHeader() throws IOException {
        this._connection.commitResponse();
        super.commitHeader();
    }

    public void commit() throws IOException {
        if (this.isCommitted()) {
            return;
        }
        super.commit();
        HttpRequest request = this.getRequest();
        if (request != null) {
            request.setHandled(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public HttpResponse() {
        this._version = "HTTP/1.0";
        this._state = 0;
    }

    public HttpResponse(HttpConnection connection) {
        super(connection);
        this._version = "HTTP/1.0";
        this._state = 0;
    }

    static {
        try {
            Field[] fields = (class$Lorg$mortbay$http$HttpResponse != null ? class$Lorg$mortbay$http$HttpResponse : (class$Lorg$mortbay$http$HttpResponse = HttpResponse.class$("org.mortbay.http.HttpResponse"))).getDeclaredFields();
            int f = fields.length;
            while (f-- > 0) {
                int m = fields[f].getModifiers();
                String name = fields[f].getName();
                if (!Modifier.isFinal(m) || !Modifier.isStatic(m) || !fields[f].getType().equals(Integer.TYPE) || !name.startsWith("__") || !Character.isDigit(name.charAt(2))) continue;
                String message = name.substring(6);
                message = message.replace('_', ' ');
                __statusMsg.put(fields[f].get(null), message);
            }
        }
        catch (Exception e) {
            Code.warning(e);
        }
        __Continue = "HTTP/1.1 100 Continue\r\n\r\n".getBytes();
    }
}

