/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mortbay.http.ChunkableInputStream;
import org.mortbay.http.ChunkableOutputStream;
import org.mortbay.http.HandlerContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.OutputObserver;
import org.mortbay.util.Code;
import org.mortbay.util.StringUtil;

public class HttpConnection
implements OutputObserver {
    private HttpListener _listener;
    private ChunkableInputStream _inputStream;
    private ChunkableOutputStream _outputStream;
    private boolean _persistent;
    private boolean _close;
    private boolean _keepAlive;
    private String _version;
    private int _dotVersion;
    private boolean _outputSetup;
    private HttpRequest _request;
    private HttpResponse _response;
    private Thread _handlingThread;
    private InetAddress _remoteAddr;
    private String _remoteHost;
    private HttpServer _httpServer;
    private Object _connection;
    private HashMap _codingParams;
    private ArrayList _codings;
    private boolean _statsOn;
    private long _tmpTime;
    private long _openTime;
    private long _reqTime;
    private int _requests;
    private Object _object;

    public InetAddress getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        if (this._remoteHost == null) {
            if (this._remoteAddr == null) {
                return "127.0.0.1";
            }
            this._remoteHost = this._remoteAddr.getHostAddress();
        }
        return this._remoteHost;
    }

    public ChunkableInputStream getInputStream() {
        return this._inputStream;
    }

    public ChunkableOutputStream getOutputStream() {
        return this._outputStream;
    }

    public Object getConnection() {
        return this._connection;
    }

    public HttpRequest getRequest() {
        return this._request;
    }

    public HttpResponse getResponse() {
        return this._response;
    }

    public void forceClose() {
        this._persistent = false;
        this._close = true;
    }

    public void close() throws IOException {
        try {
            this._outputStream.close();
            this._inputStream.close();
        }
        finally {
            Object var2_1 = null;
            if (this._handlingThread != null) {
                this._handlingThread.interrupt();
            }
        }
    }

    public HttpListener getListener() {
        return this._listener;
    }

    public HttpServer getHttpServer() {
        return this._httpServer;
    }

    public String getDefaultScheme() {
        return this._listener.getDefaultScheme();
    }

    public String getHost() {
        return this._listener.getHost();
    }

    public int getPort() {
        return this._listener.getPort();
    }

    public Object getObject() {
        return this._object;
    }

    public void setObject(Object o) {
        this._object = o;
    }

    private void verifyHTTP_1_0() throws HttpException, IOException {
        int content_length = this._request.getIntField("Content-Length");
        if (content_length >= 0) {
            this._inputStream.setContentLength(content_length);
        } else if (content_length < 0) {
            this._inputStream.setContentLength(0);
        }
        this._persistent = this._keepAlive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyHTTP_1_1() throws HttpException, IOException {
        String host = this._request.getField("Host");
        if (host == null || host.length() == 0) {
            throw new HttpException(HttpResponse.__400_Bad_Request);
        }
        Enumeration transfer_coding = this._request.getFieldValues("Transfer-Encoding", ", \t");
        boolean input_encodings = false;
        if (transfer_coding != null) {
            if (this._codingParams == null) {
                this._codingParams = new HashMap(7);
                this._codings = new ArrayList(4);
            } else {
                this._codingParams.clear();
                this._codings.clear();
            }
            while (transfer_coding.hasMoreElements()) {
                this._codings.add(transfer_coding.nextElement());
            }
            int i = this._codings.size();
            while (i-- > 0) {
                String value = this._codings.get(i).toString();
                String coding = HttpFields.valueParameters(value, this._codingParams);
                if ("identity".equalsIgnoreCase(coding)) continue;
                input_encodings = true;
                if ("chunked".equalsIgnoreCase(coding)) {
                    if (i + 1 < this._codings.size() || this._codingParams.size() > 0) {
                        throw new HttpException(400);
                    }
                    this._inputStream.setChunking();
                    continue;
                }
                this.getHttpServer().getHttpEncoding().enableEncoding(this._inputStream, coding, (Map)this._codingParams);
            }
        }
        int content_length = this._request.getIntField("Content-Length");
        String content_type = this._request.getField("Content-Type");
        if (input_encodings) {
            if (!this._inputStream.isChunking()) {
                throw new HttpException(HttpResponse.__400_Bad_Request);
            }
        } else if (content_length >= 0) {
            this._inputStream.setContentLength(content_length);
        } else if (content_type == null || content_type.length() == 0) {
            this._inputStream.setContentLength(0);
        } else {
            this._inputStream.setContentLength(0);
        }
        String expect = this._request.getField("Expect");
        if (expect != null && expect.length() > 0) {
            if (!StringUtil.asciiToLowerCase(expect).equals("100-continue")) throw new HttpException(HttpResponse.__417_Expectation_Failed);
            if (this._inputStream.available() <= 0) {
                this._outputStream.getRawStream().write(HttpResponse.__Continue);
                this._outputStream.getRawStream().flush();
            }
        } else if (this._inputStream.available() <= 0 && (HttpRequest.__PUT.equals(this._request.getMethod()) || HttpRequest.__POST.equals(this._request.getMethod()))) {
            this._outputStream.getRawStream().write(HttpResponse.__Continue);
            this._outputStream.getRawStream().flush();
        }
        this._persistent = !this._close;
    }

    public void outputNotify(ChunkableOutputStream out, int action) throws IOException {
        if (this._response == null) {
            return;
        }
        switch (action) {
            case 0: {
                if (this._outputSetup) break;
                this.setupOutputStream();
                break;
            }
            case 1: {
                this._outputSetup = false;
                break;
            }
            case 2: {
                if (this._response.getState() != 0) break;
                this._response.commitHeader();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this._response.complete();
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public void setupOutputStream() throws IOException {
        block19: {
            Enumeration transfer_coding;
            block18: {
                if (this._outputSetup) {
                    return;
                }
                this._outputSetup = true;
                transfer_coding = this._response.getFieldValues("Transfer-Encoding", ", \t");
                if (transfer_coding != null && transfer_coding.hasMoreElements()) break block18;
                switch (this._dotVersion) {
                    case 1: {
                        if (this._listener.getHttpServer().isChunkingForced() || !"close".equals(this._response.getField("Connection")) && this._response.getField("Content-Length") == null) {
                            this._response.removeField("Content-Length");
                            this._response.setField("Transfer-Encoding", "chunked");
                            this._outputStream.setChunking();
                            break;
                        }
                        break block19;
                    }
                    case 0: {
                        if (!this._keepAlive || !this._persistent || 304 != this._response.getStatus() && this._response.getField("Content-Length") == null || "close".equals(this._response.getField("Connection"))) {
                            this._persistent = false;
                            if (this._keepAlive) {
                                this._response.setField("Connection", "close");
                            }
                            this._keepAlive = false;
                            break;
                        }
                        if (this._keepAlive) {
                            this._response.setField("Connection", "keep-alive");
                            break;
                        }
                        break block19;
                    }
                    default: {
                        this._keepAlive = false;
                        this._persistent = false;
                    }
                }
                break block19;
            }
            if (this._dotVersion < 1) {
                this._response.removeField("Transfer-Encoding");
                throw new HttpException(HttpResponse.__501_Not_Implemented, "Transfer-Encoding not supported in HTTP/1.0");
            }
            this._response.removeField("Content-Length");
            if (this._codingParams == null) {
                this._codingParams = new HashMap(7);
                this._codings = new ArrayList(4);
            } else {
                this._codingParams.clear();
                this._codings.clear();
            }
            while (transfer_coding.hasMoreElements()) {
                this._codings.add(transfer_coding.nextElement());
            }
            int i = this._codings.size();
            while (i-- > 0) {
                String value = this._codings.get(i).toString();
                String coding = HttpFields.valueParameters(value, this._codingParams);
                if ("identity".equalsIgnoreCase(coding) || "identity".equalsIgnoreCase(coding)) continue;
                if ("chunked".equalsIgnoreCase(coding)) {
                    if (i + 1 < this._codings.size() || this._codingParams.size() > 0) {
                        throw new HttpException(HttpResponse.__400_Bad_Request, "Missing or incorrect chunked transfer-encoding");
                    }
                    this._outputStream.setChunking();
                    continue;
                }
                List te = this._request.getAcceptableTransferCodings();
                if (te == null || !te.contains(coding)) {
                    throw new HttpException(HttpResponse.__501_Not_Implemented, "User agent does not accept " + coding + " transfer-encoding");
                }
                this.getHttpServer().getHttpEncoding().enableEncoding(this._outputStream, coding, (Map)this._codingParams);
            }
        }
        if (HttpRequest.__HEAD.equals(this._request.getMethod())) {
            this._outputStream.nullOutput();
        }
    }

    void commitResponse() throws IOException {
        this._outputSetup = true;
        this._close = "close".equals(this._response.getField("Connection"));
        if (!(this._close || this._listener.isStarted() && !this._listener.isOutOfResources())) {
            this._close = true;
            this._response.setField("Connection", "close");
        }
        if (this._close) {
            this._persistent = false;
        }
        int status = this._response.getStatus();
        if (!(this._outputStream.isWritten() || this._response.containsField("Transfer-Encoding") || this._response.containsField("Content-Length") || status == 304 || status == 204)) {
            if (this._persistent) {
                switch (this._dotVersion) {
                    case 0: {
                        this._close = true;
                        this._persistent = false;
                        this._response.setField("Connection", "close");
                        break;
                    }
                    case 1: {
                        this._response.setField("Transfer-Encoding", "chunked");
                        this._outputStream.setChunking();
                        break;
                    }
                    default: {
                        this._close = true;
                        this._response.setField("Connection", "close");
                        break;
                    }
                }
            } else {
                this._close = true;
                this._response.setField("Connection", "close");
            }
        }
    }

    private void exception(Throwable e) {
        try {
            boolean gotIOException = false;
            if (e instanceof HttpException) {
                if (this._request == null) {
                    Code.warning(e.toString());
                } else {
                    Code.warning(this._request.getRequestLine() + " " + e.toString());
                }
                Code.debug(e);
            } else if (e instanceof IOException) {
                gotIOException = true;
                if (Code.verbose()) {
                    Code.debug(e);
                } else if (Code.debug()) {
                    Code.debug(e.toString());
                }
            } else if (this._request == null) {
                Code.warning(e);
            } else {
                Code.warning(this._request.getRequestLine(), e);
            }
            this._persistent = false;
            if (this._response != null && !this._response.isCommitted()) {
                this._response.reset();
                this._response.removeField("Transfer-Encoding");
                this._response.setField("Connection", "close");
                this._response.sendError(500, e);
                if (gotIOException) {
                    if (this._request == null) {
                        Code.warning(e);
                    } else {
                        Code.warning(this._request.getRequestLine(), e);
                    }
                }
            }
        }
        catch (Exception ex) {
            Code.ignore(ex);
        }
    }

    protected HandlerContext service(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (this._httpServer == null) {
            throw new HttpException(HttpResponse.__503_Service_Unavailable);
        }
        return this._httpServer.service(request, response);
    }

    public void handle() {
        while (this._listener.isStarted()) {
            if (!this.handleNext()) break;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean handleNext() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void destroy() {
        if (this._request != null) {
            this._request.destroy();
        }
        if (this._response != null) {
            this._response.destroy();
        }
        this._request = null;
        this._response = null;
        this._handlingThread = null;
        try {
            this.close();
        }
        catch (IOException e) {
            Code.ignore(e);
        }
        catch (Exception e) {
            Code.warning(e);
        }
        if (this._statsOn) {
            this._tmpTime = System.currentTimeMillis();
            if (this._reqTime > 0L) {
                this._httpServer.statsEndRequest(this._tmpTime - this._reqTime, false);
            }
            this._httpServer.statsCloseConnection(this._tmpTime - this._openTime, this._requests);
        }
    }

    public HttpConnection(HttpListener listener, InetAddress remoteAddr, InputStream in, OutputStream out, Object connection) {
        Code.debug((Object)"new HttpConnection: ", connection);
        this._listener = listener;
        this._remoteAddr = remoteAddr;
        this._inputStream = new ChunkableInputStream(in);
        this._outputStream = new ChunkableOutputStream(out);
        this._outputStream.addObserver(this);
        this._outputSetup = false;
        if (this._listener != null) {
            this._httpServer = this._listener.getHttpServer();
        }
        this._connection = connection;
        boolean bl = this._statsOn = this._httpServer != null && this._httpServer.getStatsOn();
        if (this._statsOn) {
            this._openTime = System.currentTimeMillis();
            this._httpServer.statsOpenConnection();
        }
        this._reqTime = 0L;
        this._requests = 0;
    }
}

