/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.UserRealm;
import org.mortbay.util.Code;
import org.mortbay.util.Password;
import org.mortbay.util.Resource;

public class HashUserRealm
extends HashMap
implements UserRealm {
    private String _name;
    private HashMap _roles = new HashMap(7);

    public void load(String config) throws IOException {
        Code.debug((Object)"Load ", this, (Object)" from ", config);
        Properties properties = new Properties();
        Resource resource = Resource.newResource(config);
        properties.load(resource.getInputStream());
        Iterator iter = ((Hashtable)properties).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String username = entry.getKey().toString().trim();
            String credentials = entry.getValue().toString().trim();
            String roles = null;
            int c = credentials.indexOf(44);
            if (c > 0) {
                roles = credentials.substring(c + 1).trim();
                credentials = credentials.substring(0, c).trim();
            }
            if (username == null || username.length() <= 0 || credentials == null || credentials.length() <= 0) continue;
            this.put(username, credentials);
            if (roles == null || roles.length() <= 0) continue;
            StringTokenizer tok = new StringTokenizer(roles, ", ");
            while (tok.hasMoreTokens()) {
                this.addUserToRole(username, tok.nextToken());
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public synchronized UserPrincipal getUser(String username) {
        return (UserPrincipal)super.get(username);
    }

    public Object put(Object name, Object credentials) {
        if (credentials instanceof UserPrincipal) {
            return super.put(name.toString(), credentials);
        }
        if (credentials instanceof Password) {
            return super.put(name, new User(name.toString(), (Password)credentials));
        }
        if (credentials != null) {
            return super.put(name, new User(name.toString(), new Password(this._name, credentials.toString())));
        }
        return null;
    }

    public synchronized void addUserToRole(String userName, String roleName) {
        HashSet<String> userSet = (HashSet<String>)this._roles.get(roleName);
        if (userSet == null) {
            userSet = new HashSet<String>(11);
            this._roles.put(roleName, userSet);
        }
        userSet.add(userName);
    }

    public boolean isUserInRole(UserPrincipal user, String roleName) {
        if (user == null || user.getUserRealm() != this) {
            return false;
        }
        if ("org.mortbay.http.User".equals(roleName)) {
            return true;
        }
        HashSet userSet = (HashSet)this._roles.get(roleName);
        return userSet != null && userSet.contains(user.getName());
    }

    public String toString() {
        return "Realm[" + this._name + "]";
    }

    public void dump(PrintStream out) {
        out.println(this + ":");
        out.println(super.toString());
        out.println(this._roles);
    }

    public HashUserRealm(String name) {
        this._name = name;
    }

    public HashUserRealm(String name, String config) throws IOException {
        this._name = name;
        this.load(config);
    }

    private class User
    implements UserPrincipal {
        private String _name;
        private Password _pw;

        public UserRealm getUserRealm() {
            return HashUserRealm.this;
        }

        public String getName() {
            return this._name;
        }

        public boolean authenticate(String password, HttpRequest request) {
            return this._pw != null && this._pw.check(password);
        }

        public boolean isUserInRole(String role) {
            return HashUserRealm.this.isUserInRole(this, role);
        }

        public String toString() {
            return this._name;
        }

        User(String name, Password password) {
            this._name = name;
            this._pw = password;
            this._pw.zero();
        }
    }
}

