/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.mortbay.http.HttpFields;
import org.mortbay.http.OutputObserver;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.ByteBufferOutputStream;
import org.mortbay.util.Code;
import org.mortbay.util.IO;

public class ChunkableOutputStream
extends FilterOutputStream {
    static final String __CRLF = "\r\n";
    static final byte[] __CRLF_B = new byte[]{13, 10};
    static final byte[] __CHUNK_EOF_B = new byte[]{48, 13, 10};
    public static final Class[] __filterArg = new Class[]{class$Ljava$io$OutputStream != null ? class$Ljava$io$OutputStream : (class$Ljava$io$OutputStream = ChunkableOutputStream.class$("java.io.OutputStream"))};
    OutputStream _realOut;
    ByteBufferOutputStream _buffer = (ByteBufferOutputStream)this.out;
    boolean _chunking;
    HttpFields _trailer;
    boolean _committed;
    boolean _written;
    int _filters;
    ArrayList _observers;
    ByteArrayISO8859Writer _rawWriter;
    boolean _nulled = false;
    int _bytes;
    private static /* synthetic */ Class class$Ljava$io$OutputStream;

    public OutputStream getRawStream() {
        return this._realOut;
    }

    public Writer getRawWriter() {
        if (this._rawWriter == null) {
            this._rawWriter = new ByteArrayISO8859Writer(2048);
        }
        return this._rawWriter;
    }

    public boolean isWritten() {
        return this._written;
    }

    public boolean isCommitted() {
        return this._committed;
    }

    public int getBufferCapacity() {
        return this._buffer.getCapacity();
    }

    public void setBufferCapacity(int capacity) throws IllegalStateException {
        if (capacity <= this.getBufferCapacity()) {
            return;
        }
        if (this._buffer.size() > 0) {
            throw new IllegalStateException("Buffer is not empty");
        }
        if (this._committed) {
            throw new IllegalStateException("Output committed");
        }
        if (this.out != this._buffer) {
            throw new IllegalStateException("Filter(s) installed");
        }
        this._buffer.ensureCapacity(capacity);
    }

    public int getBytesWritten() {
        return this._bytes;
    }

    public void resetBuffer() throws IllegalStateException {
        if (this._committed) {
            throw new IllegalStateException("Output committed");
        }
        if (Code.verbose()) {
            Code.debug("resetBuffer()");
        }
        ArrayList save_observers = this._observers;
        this._observers = null;
        try {
            try {
                this.out.flush();
                this.out.close();
            }
            catch (Exception e) {
                Code.ignore(e);
                Object var3_3 = null;
                this._observers = save_observers;
            }
            Object var3_2 = null;
            this._observers = save_observers;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this._observers = save_observers;
            throw throwable;
        }
        this._buffer.reset();
        this._bytes = 0;
        this.out = this._buffer;
        this._filters = 0;
        this._written = false;
        this._committed = false;
        try {
            this.notify(1);
        }
        catch (IOException e) {
            Code.ignore(e);
        }
    }

    public void addObserver(OutputObserver observer) {
        if (this._observers == null) {
            this._observers = new ArrayList(4);
        }
        this._observers.add(observer);
    }

    public void nullOutput() throws IOException {
        this._nulled = true;
    }

    public boolean isNullOutput() throws IOException {
        return this._nulled;
    }

    public void setChunking() throws IOException {
        this._chunking = true;
    }

    public void resetStream() throws IllegalStateException {
        if (this.isChunking()) {
            throw new IllegalStateException("Chunking");
        }
        if (Code.verbose()) {
            Code.debug("resetStream()");
        }
        this._trailer = null;
        this._committed = false;
        this._written = false;
        this._buffer.reset();
        this.out = this._buffer;
        this._filters = 0;
        this._nulled = false;
        this._bytes = 0;
        if (this._rawWriter != null) {
            this._rawWriter.reset();
        }
    }

    public boolean isChunking() {
        return this._chunking;
    }

    public void insertFilter(Constructor filter, Object[] args) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        if (args == null || args.length < 1) {
            args = new Object[]{this.out};
        }
        this.out = (OutputStream)filter.newInstance(args);
        ++this._filters;
    }

    public void setTrailer(HttpFields trailer) {
        if (!this.isChunking()) {
            throw new IllegalStateException("Not Chunking");
        }
        this._trailer = trailer;
    }

    public void write(int b) throws IOException {
        if (!this._written) {
            this._written = true;
            this.notify(0);
        }
        ++this._bytes;
        this.out.write(b);
        if (this._buffer.isFull()) {
            this.flush();
        }
    }

    public void write(byte[] b) throws IOException {
        if (!this._written) {
            this._written = true;
            this.notify(0);
        }
        this._bytes += b.length;
        this.out.write(b);
        if (this._buffer.isFull()) {
            this.flush();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (!this._written) {
            this._written = true;
            this.notify(0);
        }
        this._bytes += len;
        this.out.write(b, off, len);
        if (this._buffer.isFull()) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        this.flush(false);
    }

    public void flush(boolean endChunking) throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        int size = this._buffer.size();
        boolean commiting = false;
        if (!this._committed && (size > 0 || this._rawWriter != null && this._rawWriter.length() > 0)) {
            this._committed = true;
            commiting = true;
            this.notify(2);
            if (this.out != null) {
                this.out.flush();
            }
            size = this._buffer.size();
        }
        try {
            if (this._nulled) {
                if (this._rawWriter != null) {
                    this._rawWriter.writeTo(this._realOut);
                }
            } else {
                Writer writer;
                if (this._chunking) {
                    writer = this.getRawWriter();
                    if (size > 0) {
                        writer.write(Integer.toString(size, 16));
                        writer.write(__CRLF);
                        writer.flush();
                        this._buffer.write(__CRLF_B);
                    }
                    if (endChunking) {
                        this._buffer.write(__CHUNK_EOF_B);
                        if (this._trailer == null) {
                            this._buffer.write(__CRLF_B);
                        }
                    }
                }
                if (this._rawWriter != null && this._rawWriter.length() > 0) {
                    this._buffer.prewrite(this._rawWriter.getBuf(), 0, this._rawWriter.length());
                }
                if (this._trailer != null && endChunking) {
                    writer = this.getRawWriter();
                    this._rawWriter.reset();
                    this._trailer.write(writer);
                    this._rawWriter.writeTo(this._buffer);
                }
                if (this._buffer.size() > 0) {
                    this._buffer.writeTo(this._realOut);
                }
            }
            this._realOut.flush();
        }
        finally {
            Object var5_5 = null;
            this._buffer.reset();
            if (this._rawWriter != null) {
                this._rawWriter.reset();
            }
            if (endChunking) {
                if (!this._chunking) {
                    throw new IllegalStateException("Not Chunking");
                }
                this._chunking = false;
            }
            if (commiting) {
                this.notify(3);
            }
        }
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        try {
            this.notify(4);
            this.out.close();
            this.out = null;
            if (this._chunking) {
                this.flush(true);
            } else {
                this.flush(false);
                this._realOut.close();
            }
            this.notify(5);
        }
        catch (IOException e) {
            Code.ignore(e);
        }
    }

    private void notify(int action) throws IOException {
        if (this._observers != null) {
            int i = 0;
            while (i < this._observers.size()) {
                ((OutputObserver)this._observers.get(i)).outputNotify(this, action);
                ++i;
            }
        }
    }

    public void write(InputStream in, int len) throws IOException {
        IO.copy(in, this, (long)len);
    }

    public void println() throws IOException {
        this.write("\n".getBytes());
    }

    public void println(Object o) throws IOException {
        if (o != null) {
            this.write(o.toString().getBytes());
        }
        this.write("\n".getBytes());
    }

    public void print(Object o) throws IOException {
        if (o != null) {
            this.write(o.toString().getBytes());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ChunkableOutputStream(OutputStream outputStream) {
        super(new ByteBufferOutputStream());
        this._realOut = outputStream;
        this._committed = false;
        this._written = false;
    }
}

