/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.EmbededServletOptions;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.jasper.servlet.ServletEngine;

public class JspServlet
extends HttpServlet {
    static boolean firstTime = true;
    static boolean jdk12 = false;
    protected ServletContext context = null;
    protected Hashtable jsps = new Hashtable();
    protected ServletConfig config;
    protected JasperLoader loader;
    protected Options options;
    protected ClassLoader parentClassLoader;
    protected ServletEngine engine;
    protected String serverInfo;
    private final boolean insecure_TMI;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        this.serverInfo = this.context.getServerInfo();
        this.options = new EmbededServletOptions(config, this.context);
        this.parentClassLoader = (ClassLoader)this.context.getAttribute("org.apache.tomcat.classloader");
        if (this.parentClassLoader == null) {
            this.parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if (this.parentClassLoader != null) {
            Constants.debug("jsp.message.parent_class_loader_is", new Object[]{this.parentClassLoader.toString()});
        } else {
            Constants.debug("jsp.message.parent_class_loader_is", new Object[]{"<none>"});
        }
        if (this.loader == null) {
            if (jdk12) {
                try {
                    Class<?> ld = Class.forName("org.apache.jasper.servlet.JasperLoader12");
                    this.loader = (JasperLoader)ld.newInstance();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (this.loader == null) {
                this.loader = new JasperLoader();
            }
            this.loader.setParentClassLoader(this.parentClassLoader);
            this.loader.setOptions(this.options);
            Object pd = this.context.getAttribute("org.apache.tomcat.protection_domain");
            this.loader.setProtectionDomain(pd);
        }
        if (firstTime) {
            firstTime = false;
            Constants.message("jsp.message.scratch.dir.is", new Object[]{this.options.getScratchDir().toString()});
            Constants.message("jsp.message.dont.modify.servlets");
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
        }
    }

    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        boolean isErrorPage = exception != null;
        JspServletWrapper wrapper = (JspServletWrapper)this.jsps.get(jspUri);
        if (wrapper == null) {
            wrapper = new JspServletWrapper(jspUri, isErrorPage);
            this.jsps.put(jspUri, wrapper);
        }
        wrapper.service(request, response, precompile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean preCompile(HttpServletRequest request) throws ServletException {
        boolean precompile = false;
        String precom = request.getParameter("jsp_precompile");
        String qString = request.getQueryString();
        if (precom != null) {
            if (precom.equals("true")) {
                return true;
            }
            if (!precom.equals("false")) throw new ServletException("Can't have request parameter  jsp_precomile set to " + precom);
            return false;
        }
        if (qString == null) return precompile;
        if (qString.startsWith("jsp_precompile")) return true;
        if (qString.indexOf("&jsp_precompile") == -1) return precompile;
        return true;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String jspUri;
            String includeUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (includeUri == null) {
                String string = request.getServletPath();
            } else {
                jspUri = includeUri;
            }
            boolean precompile = this.preCompile(request);
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        Enumeration servlets = this.jsps.elements();
        while (servlets.hasMoreElements()) {
            ((JspServletWrapper)servlets.nextElement()).destroy();
        }
    }

    boolean loadJSP(String jspUri, String classpath, boolean isErrorPage, HttpServletRequest req, HttpServletResponse res) throws JasperException, FileNotFoundException {
        return this.loader.loadJSP(this, jspUri, classpath, isErrorPage, req, res);
    }

    protected boolean doLoadJSP(String jspUri, String classpath, boolean isErrorPage, HttpServletRequest req, HttpServletResponse res) throws JasperException, FileNotFoundException {
        Compiler compiler;
        boolean outDated;
        JspEngineContext ctxt;
        JspServletWrapper jsw;
        block13: {
            jsw = (JspServletWrapper)this.jsps.get(jspUri);
            if (jsw == null) {
                throw new JasperException("Can't happen - JspServletWrapper=null");
            }
            boolean firstTime = jsw.servletClass == null;
            ctxt = new JspEngineContext(this.loader, classpath, this.context, jspUri, isErrorPage, this.options, req, res);
            outDated = false;
            compiler = ctxt.createCompiler();
            try {
                outDated = compiler.compile();
                if (jsw.servletClass != null && !compiler.isOutDated()) break block13;
                JspServlet jspServlet = this;
                synchronized (jspServlet) {
                    if (jsw.servletClass == null || compiler.isOutDated()) {
                        outDated = compiler.compile();
                    }
                }
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (JasperException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new JasperException(Constants.getString("jsp.error.unable.compile"), ex);
            }
        }
        if (jsw.servletClass == null || outDated) {
            try {
                if (ctxt.getServletClassName() == null) {
                    compiler.computeServletClassName();
                }
                jsw.servletClass = this.loader.loadClass(ctxt.getFullClassName());
            }
            catch (ClassNotFoundException cex) {
                throw new JasperException(Constants.getString("jsp.error.unable.load"), cex);
            }
        }
        return outDated;
    }

    public boolean isOutDated(File jsp, JspCompilationContext ctxt, Mangler mangler) {
        boolean outDated;
        File jspReal = null;
        jspReal = new File(ctxt.getRealPath(jsp.getPath()));
        File classFile = new File(mangler.getClassFileName());
        if (classFile.exists()) {
            boolean bl = classFile.lastModified() < jspReal.lastModified();
        } else {
            outDated = true;
        }
        return outDated;
    }

    static /* synthetic */ boolean access$0(JspServlet jspServlet) {
        return jspServlet.insecure_TMI;
    }

    public JspServlet() {
        this.insecure_TMI = false;
    }

    static {
        try {
            Class.forName("java.security.PrivilegedAction");
            jdk12 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class JspServletWrapper {
        Servlet theServlet;
        String jspUri;
        boolean isErrorPage;
        Class servletClass;

        private void load() throws JasperException, ServletException {
            try {
                this.destroy();
                this.theServlet = (Servlet)this.servletClass.newInstance();
            }
            catch (Exception ex) {
                throw new JasperException(ex);
            }
            this.theServlet.init(JspServlet.this.config);
            if (this.theServlet instanceof HttpJspBase) {
                HttpJspBase h = (HttpJspBase)this.theServlet;
                h.setClassLoader(JspServlet.this.parentClassLoader);
            }
        }

        private void loadIfNecessary(HttpServletRequest req, HttpServletResponse res) throws JasperException, ServletException, FileNotFoundException {
            String accordingto;
            String cp = (String)JspServlet.this.context.getAttribute("org.apache.tomcat.jsp_classpath");
            if (cp == null || cp.equals("")) {
                accordingto = "according to the init parameter";
                cp = JspServlet.this.options.getClassPath();
            } else {
                accordingto = "according to the Servlet Engine";
            }
            Constants.message("jsp.message.cp_is", new Object[]{accordingto, cp == null ? "" : cp});
            if (JspServlet.this.loadJSP(this.jspUri, cp, this.isErrorPage, req, res) || this.theServlet == null) {
                this.load();
            }
        }

        public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException, FileNotFoundException {
            block9: {
                try {
                    this.loadIfNecessary(request, response);
                    if (precompile) {
                        return;
                    }
                    if (this.theServlet instanceof SingleThreadModel) {
                        JspServletWrapper jspServletWrapper = this;
                        synchronized (jspServletWrapper) {
                            this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                            break block9;
                        }
                    }
                    this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                }
                catch (FileNotFoundException ex) {
                    try {
                        response.sendError(404, Constants.getString("jsp.error.file.not.found", new Object[0]));
                    }
                    catch (IllegalStateException ise) {
                        // empty catch block
                    }
                    return;
                }
            }
        }

        public void destroy() {
            if (this.theServlet != null) {
                this.theServlet.destroy();
            }
        }

        JspServletWrapper(String jspUri, boolean isErrorPage) {
            this.jspUri = jspUri;
            this.isErrorPage = isErrorPage;
            this.theServlet = null;
        }
    }
}

