/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspUtil;
import org.mortbay.xml.XmlParser;

public class TagLibraryInfoImpl
extends TagLibraryInfo {
    private static final String TLD = "META-INF/taglib.tld";
    private static final String WEBAPP_INF = "/WEB-INF/web.xml";
    XmlParser.Node tld;
    Hashtable jarEntries;
    JspCompilationContext ctxt;

    private final void print(String name, String value, PrintWriter w) {
        if (value != null) {
            w.print(name + " = {\n\t");
            w.print(value);
            w.print("\n}\n");
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.print("tlibversion", this.tlibversion, out);
        this.print("jspversion", this.jspversion, out);
        this.print("shortname", this.shortname, out);
        this.print("urn", this.urn, out);
        this.print("info", this.info, out);
        int i = 0;
        while (i < this.tags.length) {
            out.println(this.tags[i].toString());
            ++i;
        }
        return sw.toString();
    }

    private InputStream getResourceAsStream(String uri) throws FileNotFoundException {
        if (uri.indexOf(58) > 0) {
            return this.ctxt.getResourceAsStream(uri);
        }
        String real = this.ctxt.getRealPath(uri);
        return real == null ? null : new FileInputStream(real);
    }

    private boolean isRelativeURI(String uri) {
        return uri.indexOf(58) == -1;
    }

    private void parseTLD(InputStream in) throws JasperException {
        this.tld = JspUtil.parseXMLDoc(in, "/org/apache/jasper/resources/web-jsptaglib_1_1.dtd", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN");
        Vector<TagInfo> tagVector = new Vector<TagInfo>();
        Iterator list = this.tld.iterator();
        while (list.hasNext()) {
            String t;
            Object tmp = list.next();
            if (!(tmp instanceof XmlParser.Node)) continue;
            XmlParser.Node e = (XmlParser.Node)tmp;
            String tname = e.getTag();
            if (tname.equals("tlibversion")) {
                t = e.toString(false, true);
                if (t == null) continue;
                this.tlibversion = t;
                continue;
            }
            if (tname.equals("jspversion")) {
                t = e.toString(false, true);
                if (t == null) continue;
                this.jspversion = t;
                continue;
            }
            if (tname.equals("shortname")) {
                t = e.toString(false, true);
                if (t == null) continue;
                this.shortname = t;
                continue;
            }
            if (tname.equals("uri")) {
                t = e.toString(false, true);
                if (t == null) continue;
                this.urn = t;
                continue;
            }
            if (tname.equals("info")) {
                t = e.toString(false, true);
                if (t == null) continue;
                this.info = t;
                continue;
            }
            if (tname.equals("tag")) {
                tagVector.addElement(this.createTagInfo(e));
                continue;
            }
            Constants.warning("jsp.warning.unknown.element.in.TLD", new Object[]{e.getTag()});
        }
        this.tags = new TagInfo[tagVector.size()];
        tagVector.copyInto(this.tags);
    }

    private TagInfo createTagInfo(XmlParser.Node elem) throws JasperException {
        String name = null;
        String tagclass = null;
        String teiclass = null;
        String bodycontent = "JSP";
        String info = null;
        Vector<TagAttributeInfo> attributeVector = new Vector<TagAttributeInfo>();
        Iterator list = elem.iterator();
        while (list.hasNext()) {
            String t;
            Object tmp = list.next();
            if (!(tmp instanceof XmlParser.Node)) continue;
            XmlParser.Node e = (XmlParser.Node)tmp;
            String tname = e.getTag();
            if (tname.equals("name")) {
                t = e.toString(false, true);
                if (t == null) continue;
                name = t;
                continue;
            }
            if (tname.equals("tagclass")) {
                t = e.toString(false, true);
                if (t == null) continue;
                tagclass = t;
                continue;
            }
            if (tname.equals("teiclass")) {
                t = e.toString(false, true);
                if (t == null) continue;
                teiclass = t;
                continue;
            }
            if (tname.equals("bodycontent")) {
                t = e.toString(false, true);
                if (t == null) continue;
                bodycontent = t;
                continue;
            }
            if (tname.equals("info")) {
                t = e.toString(false, true);
                if (t == null) continue;
                info = t;
                continue;
            }
            if (tname.equals("attribute")) {
                attributeVector.addElement(this.createAttribute(e));
                continue;
            }
            Constants.warning("jsp.warning.unknown.element.in.tag", new Object[]{e.getTag()});
        }
        Object[] tagAttributeInfo = new TagAttributeInfo[attributeVector.size()];
        attributeVector.copyInto(tagAttributeInfo);
        TagExtraInfo tei = null;
        if (teiclass != null && !teiclass.equals("")) {
            try {
                Class<?> teiClass = this.ctxt.getClassLoader().loadClass(teiclass);
                tei = (TagExtraInfo)teiClass.newInstance();
            }
            catch (ClassNotFoundException cex) {
                Constants.warning("jsp.warning.teiclass.is.null", new Object[]{teiclass, cex.getMessage()});
            }
            catch (IllegalAccessException iae) {
                Constants.warning("jsp.warning.teiclass.is.null", new Object[]{teiclass, iae.getMessage()});
            }
            catch (InstantiationException ie) {
                Constants.warning("jsp.warning.teiclass.is.null", new Object[]{teiclass, ie.getMessage()});
            }
        }
        TagInfo taginfo = new TagInfo(name, tagclass, bodycontent, info, (TagLibraryInfo)this, tei, (TagAttributeInfo[])tagAttributeInfo);
        return taginfo;
    }

    TagAttributeInfo createAttribute(XmlParser.Node elem) {
        String name = null;
        boolean required = false;
        boolean rtexprvalue = false;
        boolean reqTime = false;
        String type = null;
        Iterator list = elem.iterator();
        while (list.hasNext()) {
            String t;
            Object tmp = list.next();
            if (!(tmp instanceof XmlParser.Node)) continue;
            XmlParser.Node e = (XmlParser.Node)tmp;
            String tname = e.getTag();
            if (tname.equals("name")) {
                t = e.toString(false, true);
                if (t == null) continue;
                name = t;
                continue;
            }
            if (tname.equals("required")) {
                t = e.toString(false, true);
                if (t == null) continue;
                required = Boolean.valueOf(t);
                continue;
            }
            if (tname.equals("rtexprvalue")) {
                t = e.toString(false, true);
                if (t == null) continue;
                rtexprvalue = Boolean.valueOf(t);
                continue;
            }
            if (tname.equals("type")) {
                t = e.toString(false, true);
                if (t == null) continue;
                type = t;
                continue;
            }
            Constants.warning("jsp.warning.unknown.element.in.attribute", new Object[]{e.getTag()});
        }
        return new TagAttributeInfo(name, required, type, rtexprvalue);
    }

    /*
     * WARNING - void declaration
     */
    static void copy(InputStream in, String fileName) throws IOException, FileNotFoundException {
        int nRead;
        byte[] buf = new byte[1024];
        FileOutputStream out = new FileOutputStream(fileName);
        while ((nRead = in.read(buf, 0, buf.length)) != -1) {
            void var4_4;
            out.write(buf, 0, (int)var4_4);
        }
    }

    static /* synthetic */ String access$0(TagLibraryInfoImpl tagLibraryInfoImpl) {
        return tagLibraryInfoImpl.uri;
    }

    static /* synthetic */ String access$2(TagLibraryInfoImpl tagLibraryInfoImpl) {
        return tagLibraryInfoImpl.tlibversion;
    }

    static /* synthetic */ String access$4(TagLibraryInfoImpl tagLibraryInfoImpl) {
        return tagLibraryInfoImpl.jspversion;
    }

    static /* synthetic */ String access$6(TagLibraryInfoImpl tagLibraryInfoImpl) {
        return tagLibraryInfoImpl.shortname;
    }

    static /* synthetic */ String access$8(TagLibraryInfoImpl tagLibraryInfoImpl) {
        return tagLibraryInfoImpl.urn;
    }

    static /* synthetic */ String access$10(TagLibraryInfoImpl tagLibraryInfoImpl) {
        return tagLibraryInfoImpl.info;
    }

    public TagLibraryInfoImpl(JspCompilationContext ctxt, String prefix, String uriIn) throws IOException, JasperException {
        super(prefix, uriIn);
        Iterator nList;
        this.ctxt = ctxt;
        InputStream in = null;
        URL url = null;
        boolean relativeURL = false;
        this.uri = uriIn;
        InputStream is = this.getResourceAsStream(WEBAPP_INF);
        if (is != null) {
            XmlParser.Node webtld = JspUtil.parseXMLDoc(is, "/org/apache/jasper/resources/web.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
            nList = webtld.iterator("taglib");
            while (nList.hasNext()) {
                String tagLoc = null;
                boolean match = false;
                XmlParser.Node e = (XmlParser.Node)nList.next();
                XmlParser.Node uriElem = e.get("taglib-uri");
                String tmpUri = uriElem.toString(false, true);
                if (tmpUri != null && (tmpUri = tmpUri.trim()).equals(uriIn)) {
                    match = true;
                    XmlParser.Node locElem = e.get("taglib-location");
                    tagLoc = locElem.toString(false, true);
                    if (tagLoc != null) {
                        tagLoc = tagLoc.trim();
                    }
                }
                if (!match || tagLoc == null) continue;
                this.uri = tagLoc;
                if (this.uri.startsWith("/") || !this.isRelativeURI(this.uri)) continue;
                this.uri = "/WEB-INF/" + this.uri;
            }
        }
        if (!this.uri.startsWith("/") && this.isRelativeURI(this.uri)) {
            this.uri = ctxt.resolveRelativeUri(this.uri);
        }
        if (!this.uri.endsWith("jar")) {
            in = this.getResourceAsStream(this.uri);
            if (in == null) {
                throw new JasperException(Constants.getString("jsp.error.tld_not_found", new Object[]{TLD}));
            }
            this.parseTLD(in);
        }
        if (this.uri.endsWith("jar")) {
            ZipEntry entry;
            if (!this.isRelativeURI(this.uri)) {
                url = new URL(this.uri);
                in = url.openStream();
            } else {
                relativeURL = true;
                in = this.getResourceAsStream(this.uri);
            }
            ZipInputStream zin = new ZipInputStream(in);
            this.jarEntries = new Hashtable();
            this.ctxt = ctxt;
            boolean tldFound = false;
            while ((entry = zin.getNextEntry()) != null) {
                int b;
                ByteArrayOutputStream baos;
                if (((ZipEntry)((Object)nList)).getName().equals(TLD)) {
                    baos = new ByteArrayOutputStream();
                    while (zin.available() != 0) {
                        b = ((InflaterInputStream)zin).read();
                        if (b == -1) break;
                        baos.write(b);
                    }
                    baos.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    tldFound = true;
                    this.parseTLD(bais);
                } else {
                    baos = new ByteArrayOutputStream();
                    while (zin.available() != 0) {
                        b = ((InflaterInputStream)zin).read();
                        if (b == -1) break;
                        baos.write(b);
                    }
                    baos.close();
                    this.jarEntries.put(((ZipEntry)((Object)nList)).getName(), baos.toByteArray());
                }
                zin.closeEntry();
            }
            if (!tldFound) {
                throw new JasperException(Constants.getString("jsp.error.tld_not_found", new Object[]{TLD}));
            }
        }
    }
}

