/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.TagCache;
import org.apache.jasper.compiler.TagGeneratorBase;
import org.apache.jasper.compiler.TagLibraries;

public class TagBeginGenerator
extends TagGeneratorBase
implements ServiceMethodPhase {
    String prefix;
    String shortTagName;
    Hashtable attrs;
    TagLibraryInfo tli;
    TagInfo ti;
    TagAttributeInfo[] attributes;
    String baseVarName;
    String thVarName;
    TagCache tc;
    TagData tagData;
    Mark start;
    TagLibraries libraries;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;
    private static /* synthetic */ Class class$Ljava$lang$Byte;
    private static /* synthetic */ Class class$Ljava$lang$Character;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljavax$servlet$jsp$tagext$BodyTag;

    public void init(JspCompilationContext ctxt) throws JasperException {
        this.validate();
        this.tc = this.libraries.getTagCache(this.prefix, this.shortTagName);
        if (this.tc == null) {
            this.tc = new TagCache(this.shortTagName);
            ClassLoader cl = ctxt.getClassLoader();
            Class<?> clz = null;
            try {
                clz = cl.loadClass(this.ti.getTagClassName());
            }
            catch (Exception ex) {
                throw new CompileException(this.start, Constants.getString("jsp.error.unable.loadclass", new Object[]{this.ti.getTagClassName(), ex.getMessage()}));
            }
            this.tc.setTagHandlerClass(clz);
            this.libraries.putTagCache(this.prefix, this.shortTagName, this.tc);
        }
    }

    void validate() throws JasperException {
        Hashtable attribs = (Hashtable)this.attrs.clone();
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].isRequired() && attribs.get(this.attributes[i].getName()) == null) {
                throw new CompileException(this.start, Constants.getString("jsp.error.missing_attribute", new Object[]{this.attributes[i].getName(), this.shortTagName}));
            }
            ++i;
        }
        Enumeration e = attribs.keys();
        while (e.hasMoreElements()) {
            String attr = (String)e.nextElement();
            boolean found = false;
            int i2 = 0;
            while (i2 < this.attributes.length) {
                if (attr.equals(this.attributes[i2].getName())) {
                    found = true;
                    if (this.attributes[i2].canBeRequestTime() && JspUtil.isExpression((String)attribs.get(attr))) {
                        attribs.put(attr, TagData.REQUEST_TIME_VALUE);
                    }
                }
                ++i2;
            }
            if (found) continue;
            throw new CompileException(this.start, Constants.getString("jsp.error.bad_attribute", new Object[]{attr}));
        }
        this.tagData = new TagData(attribs);
        if (!this.ti.isValid(this.tagData)) {
            throw new CompileException(this.start, Constants.getString("jsp.error.invalid_attributes"));
        }
    }

    private final void generateSetters(ServletWriter writer, String parent) throws JasperException {
        writer.println(this.thVarName + ".setPageContext(pageContext);");
        writer.println(this.thVarName + ".setParent(" + parent + ");");
        if (this.attributes.length != 0) {
            int i = 0;
            while (i < this.attributes.length) {
                String attrValue = (String)this.attrs.get(this.attributes[i].getName());
                if (attrValue != null) {
                    String attrName = this.attributes[i].getName();
                    Method m = this.tc.getSetterMethod(attrName);
                    Class<?>[] c = m.getParameterTypes();
                    attrValue = this.attributes[i].canBeRequestTime() ? (JspUtil.isExpression(attrValue) ? JspUtil.getExpr(attrValue) : this.convertString(c[0], attrValue, writer, attrName)) : this.convertString(c[0], attrValue, writer, attrName);
                    if (m == null) {
                        throw new CompileException(this.start, Constants.getString("jsp.error.unable.to_find_method", new Object[]{attrName}));
                    }
                    writer.println(this.thVarName + "." + m.getName() + "(" + attrValue + ");");
                }
                ++i;
            }
        }
    }

    public String convertString(Class c, String s, ServletWriter writer, String attrName) throws JasperException {
        if (c == (class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TagBeginGenerator.class$("java.lang.String")))) {
            return writer.quoteString(s);
        }
        if (c == Boolean.TYPE) {
            return Boolean.valueOf(s).toString();
        }
        if (c == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = TagBeginGenerator.class$("java.lang.Boolean")))) {
            return "new Boolean(" + Boolean.valueOf(s).toString() + ")";
        }
        if (c == Byte.TYPE) {
            return "((byte)" + Byte.valueOf(s).toString() + ")";
        }
        if (c == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = TagBeginGenerator.class$("java.lang.Byte")))) {
            return "new Byte((byte)" + Byte.valueOf(s).toString() + ")";
        }
        if (c == Character.TYPE) {
            if (s.length() > 1) {
                char ch = s.charAt(0);
                return "((char) " + ch + ")";
            }
            throw new NumberFormatException(Constants.getString("jsp.error.bad_string_char", new Object[0]));
        }
        if (c == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = TagBeginGenerator.class$("java.lang.Character")))) {
            if (s.length() > 1) {
                char ch = s.charAt(0);
                return "new Character((char) " + ch + ")";
            }
            throw new NumberFormatException(Constants.getString("jsp.error.bad_string_Character", new Object[0]));
        }
        if (c == Double.TYPE) {
            return Double.valueOf(s).toString();
        }
        if (c == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = TagBeginGenerator.class$("java.lang.Double")))) {
            return "new Double(" + Double.valueOf(s).toString() + ")";
        }
        if (c == Float.TYPE) {
            return Float.valueOf(s).toString() + "f";
        }
        if (c == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = TagBeginGenerator.class$("java.lang.Float")))) {
            return "new Float(" + Float.valueOf(s).toString() + "f)";
        }
        if (c == Integer.TYPE) {
            return Integer.valueOf(s).toString();
        }
        if (c == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = TagBeginGenerator.class$("java.lang.Integer")))) {
            return "new Integer(" + Integer.valueOf(s).toString() + ")";
        }
        if (c == Long.TYPE) {
            return Long.valueOf(s).toString() + "l";
        }
        if (c == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = TagBeginGenerator.class$("java.lang.Long")))) {
            return "new Long(" + Long.valueOf(s).toString() + "l)";
        }
        throw new CompileException(this.start, Constants.getString("jsp.error.unable.to_convert_string", new Object[]{c.getName(), attrName}));
    }

    public void generateServiceMethodStatements(ServletWriter writer) throws JasperException {
        TagGeneratorBase.TagVariableData top = this.topTag();
        String parent = top == null ? null : top.tagHandlerInstanceName;
        String evalVar = "_jspx_eval_" + this.baseVarName;
        TagBeginGenerator tagBeginGenerator = this;
        if (tagBeginGenerator == null) {
            throw null;
        }
        this.tagBegin(tagBeginGenerator.new TagGeneratorBase.TagVariableData(this.thVarName, evalVar));
        writer.println("/* ----  " + this.prefix + ":" + this.shortTagName + " ---- */");
        writer.println(this.ti.getTagClassName() + " " + this.thVarName + " = new " + this.ti.getTagClassName() + "();");
        this.generateSetters(writer, parent);
        VariableInfo[] vi = this.ti.getVariableInfo(this.tagData);
        this.declareVariables(writer, vi, true, false, 1);
        writer.println("try {");
        writer.pushIndent();
        writer.println("int " + evalVar + " = " + this.thVarName + ".doStartTag();");
        boolean implementsBodyTag = (class$Ljavax$servlet$jsp$tagext$BodyTag != null ? class$Ljavax$servlet$jsp$tagext$BodyTag : (class$Ljavax$servlet$jsp$tagext$BodyTag = TagBeginGenerator.class$("javax.servlet.jsp.tagext.BodyTag"))).isAssignableFrom(this.tc.getTagHandlerClass());
        this.declareVariables(writer, vi, false, true, 1);
        if (implementsBodyTag) {
            writer.println("if (" + evalVar + " == Tag.EVAL_BODY_INCLUDE)");
            writer.pushIndent();
            writer.println("throw new JspTagException(\"Since tag handler " + this.tc.getTagHandlerClass() + " implements BodyTag, it can't return Tag.EVAL_BODY_INCLUDE\");");
            writer.popIndent();
        } else {
            writer.println("if (" + evalVar + " == BodyTag.EVAL_BODY_TAG)");
            writer.pushIndent();
            writer.println("throw new JspTagException(\"Since tag handler " + this.tc.getTagHandlerClass() + " does not implement BodyTag, it can't return BodyTag.EVAL_BODY_TAG\");");
            writer.popIndent();
        }
        writer.println("if (" + evalVar + " != Tag.SKIP_BODY) {");
        writer.pushIndent();
        if (implementsBodyTag) {
            writer.println("try {");
            writer.pushIndent();
            writer.println("if (" + evalVar + " != Tag.EVAL_BODY_INCLUDE) {");
            writer.pushIndent();
            writer.println("out = pageContext.pushBody();");
            writer.println(this.thVarName + ".setBodyContent((BodyContent) out);");
            writer.popIndent();
            writer.println("}");
            writer.println(this.thVarName + ".doInitBody();");
        }
        writer.println("do {");
        writer.pushIndent();
        this.declareVariables(writer, vi, true, true, 0);
        this.declareVariables(writer, vi, false, true, 1);
    }

    public void generate(ServletWriter writer, Class phase) throws JasperException {
        this.generateServiceMethodStatements(writer);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TagBeginGenerator(Mark start, String prefix, String shortTagName, Hashtable attrs, TagLibraryInfo tli, TagInfo ti, TagLibraries libraries, Stack tagHandlerStack, Hashtable tagVarNumbers) throws JasperException {
        this.setTagHandlerStack(tagHandlerStack);
        this.setTagVarNumbers(tagVarNumbers);
        this.prefix = prefix;
        this.shortTagName = shortTagName;
        this.attrs = attrs;
        this.tli = tli;
        this.ti = ti;
        this.attributes = ti.getAttributes();
        this.baseVarName = this.getTagVarName(prefix, shortTagName);
        this.thVarName = "_jspx_th_" + this.baseVarName;
        this.start = start;
        this.libraries = libraries;
    }
}

