/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import org.apache.jasper.compiler.Mark;

public class ServletWriter {
    public static int TAB_WIDTH = 4;
    public static String SPACES = "                              ";
    int indent = 0;
    PrintWriter writer;

    public void close() throws IOException {
        this.writer.close();
    }

    public void pushIndent() {
        if ((this.indent += TAB_WIDTH) > SPACES.length()) {
            this.indent = SPACES.length();
        }
    }

    public void popIndent() {
        if ((this.indent -= TAB_WIDTH) <= 0) {
            this.indent = 0;
        }
    }

    public void printComment(Mark start, Mark stop, char[] chars) {
        if (start != null && stop != null) {
            this.println("// from=" + start);
            this.println("//   to=" + stop);
        }
        if (chars != null) {
            int i = 0;
            while (i < chars.length) {
                this.indent();
                this.print("// ");
                while (chars[i] != '\n' && i < chars.length) {
                    this.writer.print(chars[i++]);
                }
            }
        }
    }

    public String quoteString(String s) {
        if (s == null) {
            return "null";
        }
        if (s.indexOf(34) < 0 && s.indexOf(92) < 0 && s.indexOf(10) < 0 && s.indexOf(13) < 0) {
            return "\"" + s + "\"";
        }
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        sb.append('\"');
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == '\\' && i + 1 < len) {
                sb.append('\\');
                sb.append('\\');
                sb.append(s.charAt(++i));
            } else if (ch == '\"') {
                sb.append('\\');
                sb.append('\"');
            } else if (ch == '\n') {
                sb.append("\\n");
            } else if (ch == '\r') {
                sb.append("\\r");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    public void println(String line) {
        this.writer.println(SPACES.substring(0, this.indent) + line);
    }

    public void println() {
        this.writer.println("");
    }

    public void indent() {
        this.writer.print(SPACES.substring(0, this.indent));
    }

    public void print(String s) {
        this.writer.print(s);
    }

    public void printMultiLn(String multiline) {
        BufferedReader reader = new BufferedReader(new StringReader(multiline));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.println(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ServletWriter(PrintWriter writer) {
        this.writer = writer;
    }
}

