/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Stack;
import org.apache.jasper.compiler.JspReader;

public final class Mark {
    int cursor;
    int line;
    int col;
    int fileid;
    String fileName;
    String baseDir;
    char[] stream = null;
    Stack includeStack = null;
    String encoding = null;
    private JspReader reader;

    public void pushStream(char[] inStream, int inFileid, String name, String inBaseDir, String inEncoding) {
        this.includeStack.push(new IncludeState(this.cursor, this.line, this.col, this.fileid, this.fileName, this.baseDir, this.encoding, this.stream));
        this.cursor = 0;
        this.line = 0;
        this.col = 0;
        this.fileid = inFileid;
        this.fileName = name;
        this.baseDir = inBaseDir;
        this.encoding = inEncoding;
        this.stream = inStream;
    }

    public boolean popStream() {
        if (this.includeStack.size() <= 0) {
            return false;
        }
        IncludeState state = (IncludeState)this.includeStack.pop();
        this.cursor = state.cursor;
        this.line = state.line;
        this.col = state.col;
        this.fileid = state.fileid;
        this.fileName = state.fileName;
        this.baseDir = state.baseDir;
        this.stream = state.stream;
        return true;
    }

    public String toString() {
        return this.getFile() + "(" + this.line + "," + this.col + ")";
    }

    public String getFile() {
        return this.fileName;
    }

    public String toShortString() {
        return "(" + this.line + "," + this.col + ")";
    }

    public boolean equals(Object other) {
        if (other instanceof Mark) {
            Mark m = (Mark)other;
            return this.reader == m.reader && this.fileid == m.fileid && this.cursor == m.cursor && this.line == m.line && this.col == m.col;
        }
        return false;
    }

    Mark(JspReader reader, char[] inStream, int fileid, String name, String inBaseDir, String inEncoding) {
        this.reader = reader;
        this.stream = inStream;
        this.col = 0;
        this.line = 0;
        this.cursor = 0;
        this.fileid = fileid;
        this.fileName = name;
        this.baseDir = inBaseDir;
        this.encoding = inEncoding;
        this.includeStack = new Stack();
    }

    Mark(Mark other) {
        this.reader = other.reader;
        this.stream = other.stream;
        this.fileid = other.fileid;
        this.fileName = other.fileName;
        this.cursor = other.cursor;
        this.line = other.line;
        this.col = other.col;
        this.baseDir = other.baseDir;
        this.encoding = other.encoding;
        this.includeStack = new Stack();
        int i = 0;
        while (i < other.includeStack.size()) {
            this.includeStack.addElement(other.includeStack.elementAt(i));
            ++i;
        }
    }

    class IncludeState {
        int cursor;
        int line;
        int col;
        int fileid;
        String fileName;
        String baseDir;
        String encoding;
        char[] stream = null;

        IncludeState(int inCursor, int inLine, int inCol, int inFileid, String name, String inBaseDir, String inEncoding, char[] inStream) {
            this.cursor = inCursor;
            this.line = inLine;
            this.col = inCol;
            this.fileid = inFileid;
            this.fileName = name;
            this.baseDir = inBaseDir;
            this.encoding = inEncoding;
            this.stream = inStream;
        }
    }
}

