/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;

public class CharDataGenerator
extends GeneratorBase
implements ServiceMethodPhase {
    private static final int MAXSIZE = 32768;
    char[] chars;

    public void generate(ServletWriter writer, Class phase) {
        writer.indent();
        int current = 0;
        int limit = this.chars.length;
        while (current < limit) {
            int from = current;
            int to = Math.min(current + 32768, limit);
            this.generateChunk(writer, from, to);
            current = to;
        }
    }

    private void generateChunk(ServletWriter writer, int from, int to) {
        writer.print("out.write(\"");
        StringBuffer sb = new StringBuffer();
        int i = from;
        while (i < to) {
            char ch = this.chars[i];
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\r': {
                    break;
                }
                case '\n': {
                    sb.append("\\r\\n");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        writer.print(sb.toString());
        writer.print("\");\n");
    }

    public CharDataGenerator(char[] chars) {
        this.chars = chars;
    }
}

